#!/bin/sh
# wg-backup-prestart.sh - pre-start script for wg-backup.service

if [ -r /etc/default/wg_system ] ; then
    . /etc/default/wg_system

    # Create the ssh client key for sftp
    if [ ! -f ${WG_ETCDIR}/backup/ssh_id_rsa ] ; then
        /usr/bin/ssh-keygen -q -t rsa -N '' -f ${WG_ETCDIR}/backup/ssh_id_rsa
    fi

    if [ ! -r ${WG_ETCDIR}/backup/wg_backup_vars ] ; then
        # not configured so nothing to do
        exit 0
    fi

    # We need to wait for a bit for resolconf to do its job before
    # hostname resolution works. For now, we keep testing the
    # connection till we are successful or exhausted attempts.
    i=0
    echo "Testing connection to backup host. Attempt ${i}"
    while ! ${WG_BINDIR}/wg_backup.sh ${WG_ETCDIR}/backup test >/dev/null ; do
        sleep 1
        i=$(expr $i + 1)
        [ $i -lt 60 ] || break
        echo "Testing connection to backup host. Attempt ${i}"
    done
    if [ $i -eq 60 ] ; then
        echo "All attempts were unsuccessful!!"
        exit 0
    fi

    echo "Enabling remote backup..."
    ${WG_BINDIR}/wg_backup.sh ${WG_ETCDIR}/backup enable
fi
