#!/bin/sh
# wg-db-analyze.sh - Shell script to analyze daily segment tables

if [ -r /etc/default/wg_system ] ; then
    . /etc/default/wg_system

    WG_PYTHON_BIN=${WG_BINDIR}/python
    WG_ANALYZE_PYC=${WG_BINDIR}/wgdb_analyze.pyc

    if [ ! -f "${WG_PYTHON_BIN}" -o ! -x "${WG_PYTHON_BIN}" ]; then
        echo "{WG_PYTHON_BIN} does not exist or is not an executable."
        exit 1
    fi

    if [ ! -f "${WG_ANALYZE_PYC}" -o ! -s "${WG_ANALYZE_PYC}" ]; then
        echo "File ${WG_ANALYZE_PYC} does not exist or is empty."
        exit 1
    fi

    if [ -n "${WG_ANALYZE_DAYS}" ] ; then
        DAYS="-d ${WG_ANALYZE_DAYS}"
    fi
    "${WG_PYTHON_BIN}" "${WG_ANALYZE_PYC}" ${DAYS}
fi
