#!/bin/sh
# wg-get-feature-keys.sh - Shell script to get legacy appliance feature keys

if [ ! -r /etc/default/wg_system ] ; then
    exit 0
fi

. /etc/default/wg_system
interpreter="${WG_BINDIR}/python"
program="${WG_BINDIR}/wg_get_feature_keys.pyc"

if [ ! -f "$interpreter" -o ! -x "$interpreter" ]; then
    echo "Interpreter file \"$interpreter\" does not exist or is non-executable"
    exit 1
fi

if [ ! -f "$program" -o ! -s "$program" ]; then
    echo "Program file \"$program\" does not exist or is empty"
    exit 1
fi

"$interpreter" "$program"
