#!/bin/sh

delete_support_user_account() {
    if getent passwd "$WG_SUPPORT_USER" >/dev/null; then
        IPTABLES_RULES_SED='/--uid-owner '"$WG_SUPPORT_USER"'/ s/^/# /'
        sed -e "$IPTABLES_RULES_SED" /etc/iptables.rules >$IPTABLES_RULES_TMP

        if ! diff /etc/iptables.rules $IPTABLES_RULES_TMP >/dev/null; then
            echo "Updating IPTABLES configuration file /etc/iptables.rules"
            /bin/mv -bf $IPTABLES_RULES_TMP /etc/iptables.rules
            chmod u=rw,go=r /etc/iptables.rules
        fi

        echo "Removing system account $WG_SUPPORT_USER"
        deluser --remove-home $WG_SUPPORT_USER
    fi
}

deploy_windows_azure_linux_agent_config() {
    /bin/mv -bf $AGENT_CONFIG_TMP $AGENT_CONFIG
    chmod u=rw,go=r $AGENT_CONFIG
    RESTART=1
}

deploy_windows_azure_linux_agent_rotate() {
    /bin/cp -bf $AGENT_ROTATE_SRC $AGENT_ROTATE
    chmod u=rw,go=r $AGENT_ROTATE
}

deploy_windows_azure_linux_agent_script() {
    /bin/cp -bf $AGENT_SCRIPT_SRC $AGENT_SCRIPT
    chmod u=rwx,go=rx $AGENT_SCRIPT
    RESTART=1
}

install_windows_azure_linux_agent() {
    echo "Installing Azure Linux Agent"

    if ! $AGENT_SCRIPT -force -verbose -install; then
        echo "Azure Linux Agent installation failed" >&2
        cat $AGENT_LOGFILE >&2 || true
    fi
}

restart_windows_azure_linux_agent() {
    echo "Restarting Azure Linux Agent"
    initctl restart $AGENT_BASE
}

#########################
# Execution begins here #
#########################

set -eu

if [ ! -e /etc/default/wg_azure ]; then
    exit 0
fi

. /etc/default/wg_system

DEFAULTS=$WG_SHAREDIR/wg_system/defaults

AGENT_BASE=waagent
AGENT_CONFIG=/etc/$AGENT_BASE.conf
AGENT_CONFIG_SRC=$DEFAULTS/$AGENT_BASE.conf.template
AGENT_ROTATE=/etc/logrotate.d/$AGENT_BASE
AGENT_ROTATE_SRC=$DEFAULTS/wg_logrotate_$AGENT_BASE
AGENT_SCRIPT=/usr/sbin/$AGENT_BASE
AGENT_SCRIPT_SRC=$WG_BINDIR/$AGENT_BASE
AGENT_LOGFILE=/var/log/$AGENT_BASE.log
RESTART=0

AGENT_CONFIG_TMP=`mktemp`
IPTABLES_RULES_TMP=`mktemp`
trap "/bin/rm -f $AGENT_CONFIG_TMP $IPTABLES_RULES_TMP" EXIT HUP INT QUIT TERM
sed -e 's,%WG_BINDIR%,'"$WG_BINDIR"',g' $AGENT_CONFIG_SRC >$AGENT_CONFIG_TMP

case "$1" in
    (install|upgrade)
        delete_support_user_account

        if [ ! -e $AGENT_SCRIPT ]; then
            deploy_windows_azure_linux_agent_script
        elif ! cmp $AGENT_SCRIPT_SRC $AGENT_SCRIPT >/dev/null; then
            deploy_windows_azure_linux_agent_script
        fi

        if [ "$1" = install ]; then
            install_windows_azure_linux_agent
        fi

        if [ ! -e $AGENT_CONFIG ]; then
            deploy_windows_azure_linux_agent_config
        elif ! diff $AGENT_CONFIG_TMP $AGENT_CONFIG >/dev/null; then
            deploy_windows_azure_linux_agent_config
        fi

        if [ ! -e $AGENT_ROTATE ]; then
            deploy_windows_azure_linux_agent_rotate
        elif ! diff $AGENT_ROTATE_SRC $AGENT_ROTATE >/dev/null; then
            deploy_windows_azure_linux_agent_rotate
        fi

        if [ "$1" = upgrade -a "$RESTART" -eq 1 ]; then
            restart_windows_azure_linux_agent
        fi
        ;;
esac
