#!/bin/sh
# wgdevice_ssh_init.sh - Initialization task for wgdevice SSH server

_create_wgdevice_user() {
    # Create the wgdevice user account, if it doesn't already exist.
    rc=0
    getent passwd wgdevice >/dev/null || rc=$?
    if [ $rc -eq 2 ] ; then
        echo "Creating wgdevice user account"
        useradd -mU -s /bin/false wgdevice
    fi
}

_create_ssh_keys() {
    local outfile="$1"
    local keytype="$2"

    echo "Creating SSH2 ${keytype} key ..."
    /usr/bin/ssh-keygen -q -f "$outfile" -N '' -t "$keytype"
    chown wgdevice:wgdevice "$outfile" "${outfile}.pub"
}

_copy_file() {
    local srcfile="$1"
    local destfile="$2"
    local destdir=$(dirname "$destfile")

    echo "Copying $srcfile to $destfile ..."
    cp -f "$srcfile" "$destfile"
    chmod 644 "$destfile"
    chown --reference="$destdir" "$destfile"
}

if [ -r /etc/default/wg_system ] ; then
    . /etc/default/wg_system
    WGDEVICE_SSHDIR="${WG_ETCDIR}/wgdevice_ssh"
    RSA_KEY="${WGDEVICE_SSHDIR}/ssh_host_rsa_key"
    SSHD_CONFIG="${WGDEVICE_SSHDIR}/sshd_config"
    DEFAULT_CONFIG="${WG_SHAREDIR}/wg_system/defaults/wgdevice_sshd_config"

    echo "Starting task at $(date)"

    if [ ! -d "$WGDEVICE_SSHDIR" ] ; then
        mkdir -p -m0755 "$WGDEVICE_SSHDIR"
        chown  --reference="$WG_ETCDIR" "$WGDEVICE_SSHDIR"
    fi

    _create_wgdevice_user
    [ -f "$SSHD_CONFIG" ] || _copy_file "$DEFAULT_CONFIG" "$SSHD_CONFIG"
    [ -f "$RSA_KEY"   ] || _create_ssh_keys "$RSA_KEY" "rsa"

    # Make sure the PIDFILE parent directory exists.
    mkdir -m755 -p ${WG_RUNDIR}/wgdevice_sshd
    chown wgdevice:wgdevice ${WG_RUNDIR}/wgdevice_sshd

    echo "Completed task at $(date)"
fi

