
CREATE SEQUENCE appliance_id_seq start with 1;

CREATE TABLE g_deviceinfo(
   id               INTEGER DEFAULT NEXTVAL('appliance_id_seq') PRIMARY KEY,
   ip_address       TEXT NOT NULL,
   appliance_name   TEXT NOT NULL,
   type             SMALLINT NOT NULL,
   sn               TEXT NOT NULL,
   model_name       TEXT,
   timezone         TEXT,
   version          TEXT,
   active           SMALLINT DEFAULT 0,
   cluster          TEXT,
   when_join        TIMESTAMP,
   update_time      TIMESTAMP
) WITH (FILLFACTOR = 50);
CREATE UNIQUE INDEX g_deviceinfo_sn_idx ON g_deviceinfo(sn);
CREATE INDEX g_deviceinfo_cl_idx ON g_deviceinfo("cluster");

CREATE TABLE g_clusterinfo(
  id                INTEGER DEFAULT NEXTVAL('appliance_id_seq') PRIMARY KEY,
  cluster_name      TEXT NOT NULL,
  update_time       TIMESTAMP
) WITH (FILLFACTOR = 50);
CREATE UNIQUE INDEX g_clusterinfo_cn_idx ON g_clusterinfo(cluster_name);

CREATE OR REPLACE VIEW g_fireboxinfotable (
  ip_address, appliance_name, type, sn, timezone, version,
  active, cluster, cstate, when_join, update_time) AS SELECT
  ip_address, appliance_name, type, sn, timezone, version,
  active, cluster, text '', when_join, update_time FROM g_deviceinfo;

CREATE TABLE group_name(
   id               INTEGER DEFAULT NEXTVAL('appliance_id_seq') PRIMARY KEY,
   group_name       TEXT NOT NULL,
   description      TEXT
) WITH (FILLFACTOR = 50);
CREATE UNIQUE INDEX group_name_gn_idx ON group_name(group_name);

CREATE TABLE group_appliance(
   group_id         INTEGER REFERENCES group_name(id) ON DELETE CASCADE,
   appliance_id     INTEGER
) WITH (FILLFACTOR = 50);
CREATE INDEX group_appliance_gid_idx ON group_appliance(group_id);
CREATE INDEX group_appliance_aid_idx ON group_appliance(appliance_id);

CREATE TABLE g_FireboxDeletionTable(
   sn               TEXT NOT NULL,
   cluster          TEXT DEFAULT '',
   type             SMALLINT NOT NULL,
   PRIMARY KEY (sn, cluster)
);

CREATE TABLE g_MessageTagTable(
   tag_id           INTEGER PRIMARY KEY,
   tag_text         TEXT    
);
insert into g_messagetagtable select 1000,'FWAllow' where
    not exists (select 1 from g_messagetagtable where tag_id = 1000 limit 1);
insert into g_messagetagtable select 1001,'FWDeny' where
    not exists (select 1 from g_messagetagtable where tag_id = 1001 limit 1);
insert into g_messagetagtable select 1002,'FWStatus' where
    not exists (select 1 from g_messagetagtable where tag_id = 1002 limit 1);
insert into g_messagetagtable select 1003,'FWConfig' where
    not exists (select 1 from g_messagetagtable where tag_id = 1003 limit 1);
insert into g_messagetagtable select 1004,'ProxyConnBegin' where
    not exists (select 1 from g_messagetagtable where tag_id = 1004 limit 1);
insert into g_messagetagtable select 1005,'ProxyConnEnd' where
    not exists (select 1 from g_messagetagtable where tag_id = 1005 limit 1);
insert into g_messagetagtable select 1006,'ProxyMatch' where
    not exists (select 1 from g_messagetagtable where tag_id = 1006 limit 1);
insert into g_messagetagtable select 1007,'ProxyHTTPReq' where
    not exists (select 1 from g_messagetagtable where tag_id = 1007 limit 1);
insert into g_messagetagtable select 1008,'ProxyFTPReq' where
    not exists (select 1 from g_messagetagtable where tag_id = 1008 limit 1);
insert into g_messagetagtable select 1009,'ProxyTCPReq' where
    not exists (select 1 from g_messagetagtable where tag_id = 1009 limit 1);
insert into g_messagetagtable select 1010,'ProxyDNSReq' where
    not exists (select 1 from g_messagetagtable where tag_id = 1010 limit 1);
insert into g_messagetagtable select 1011,'ProxySMTPReq' where
    not exists (select 1 from g_messagetagtable where tag_id = 1011 limit 1);
insert into g_messagetagtable select 1012,'Notify' where
    not exists (select 1 from g_messagetagtable where tag_id = 1012 limit 1);
insert into g_messagetagtable select 1013,'UserLogin' where
    not exists (select 1 from g_messagetagtable where tag_id = 1013 limit 1);
insert into g_messagetagtable select 1014,'UserLogout' where
    not exists (select 1 from g_messagetagtable where tag_id = 1014 limit 1);
insert into g_messagetagtable select 1015,'UserDeny' where
    not exists (select 1 from g_messagetagtable where tag_id = 1015 limit 1);
insert into g_messagetagtable select 1016,'FWSyslog' where
    not exists (select 1 from g_messagetagtable where tag_id = 1016 limit 1);
insert into g_messagetagtable select 1017,'FWKeepAlive' where
    not exists (select 1 from g_messagetagtable where tag_id = 1017 limit 1);
insert into g_messagetagtable select 1018,'ProxyPOP3Req' where
    not exists (select 1 from g_messagetagtable where tag_id = 1018 limit 1);
insert into g_messagetagtable select 1019,'ProxyHTTPSReq' where
    not exists (select 1 from g_messagetagtable where tag_id = 1019 limit 1);
insert into g_messagetagtable select 1020,'ProxySIPReq' where
    not exists (select 1 from g_messagetagtable where tag_id = 1020 limit 1);
insert into g_messagetagtable select 1021,'ProxyH323Req' where
    not exists (select 1 from g_messagetagtable where tag_id = 1021 limit 1);
insert into g_messagetagtable select 1022,'FWIPS' where
    not exists (select 1 from g_messagetagtable where tag_id = 1022 limit 1);
insert into g_messagetagtable select 1023,'ProxyHTTPAcct' where
    not exists (select 1 from g_messagetagtable where tag_id = 1023 limit 1);
insert into g_messagetagtable select 1024,'FWAllowEnd' where
    not exists (select 1 from g_messagetagtable where tag_id = 1024 limit 1);
insert into g_messagetagtable select 1025,'ProxyIMAPReq' where
    not exists (select 1 from g_messagetagtable where tag_id = 1025 limit 1);
insert into g_messagetagtable select 2000,'SrvConfig' where
    not exists (select 1 from g_messagetagtable where tag_id = 2000 limit 1);
insert into g_messagetagtable select 2001,'SrvBegin' where
    not exists (select 1 from g_messagetagtable where tag_id = 2001 limit 1);
insert into g_messagetagtable select 2002,'SrvProcess' where
    not exists (select 1 from g_messagetagtable where tag_id = 2002 limit 1);
insert into g_messagetagtable select 2003,'SrvEnd' where
    not exists (select 1 from g_messagetagtable where tag_id = 2003 limit 1);
insert into g_messagetagtable select 2004,'SrvReqBegin' where
    not exists (select 1 from g_messagetagtable where tag_id = 2004 limit 1);
insert into g_messagetagtable select 2005,'SrvReqProcess' where
    not exists (select 1 from g_messagetagtable where tag_id = 2005 limit 1);
insert into g_messagetagtable select 2006,'SrvReqEnd' where
    not exists (select 1 from g_messagetagtable where tag_id = 2006 limit 1);
insert into g_messagetagtable select 2007,'SrvConnBegin' where
    not exists (select 1 from g_messagetagtable where tag_id = 2007 limit 1);
insert into g_messagetagtable select 2008,'SrvConnProcess' where
    not exists (select 1 from g_messagetagtable where tag_id = 2008 limit 1);
insert into g_messagetagtable select 2009,'SrvConnEnd' where
    not exists (select 1 from g_messagetagtable where tag_id = 2009 limit 1);
insert into g_messagetagtable select 2010,'SrvNotify' where
    not exists (select 1 from g_messagetagtable where tag_id = 2010 limit 1);
insert into g_messagetagtable select 2011,'SrvAuthBegin' where
    not exists (select 1 from g_messagetagtable where tag_id = 2011 limit 1);
insert into g_messagetagtable select 2012,'SrvAuthProcess' where
    not exists (select 1 from g_messagetagtable where tag_id = 2012 limit 1);
insert into g_messagetagtable select 2013,'SrvAuthEnd' where
    not exists (select 1 from g_messagetagtable where tag_id = 2013 limit 1);
insert into g_messagetagtable select 2014,'SrvAuthzBegin' where
    not exists (select 1 from g_messagetagtable where tag_id = 2014 limit 1);
insert into g_messagetagtable select 2015,'SrvAuthzProcess' where
    not exists (select 1 from g_messagetagtable where tag_id = 2015 limit 1);
insert into g_messagetagtable select 2016,'SrvAuthzEnd' where
    not exists (select 1 from g_messagetagtable where tag_id = 2016 limit 1);
insert into g_messagetagtable select 2017,'SrvKeepAlive' where
    not exists (select 1 from g_messagetagtable where tag_id = 2017 limit 1);
insert into g_messagetagtable select 8000,'Import' where
    not exists (select 1 from g_messagetagtable where tag_id = 8000 limit 1);
insert into g_messagetagtable select 8001,'Reconfig' where
    not exists (select 1 from g_messagetagtable where tag_id = 8001 limit 1);
insert into g_messagetagtable select 8002,'Auth' where
    not exists (select 1 from g_messagetagtable where tag_id = 8002 limit 1);
insert into g_messagetagtable select 8003,'Audit' where
    not exists (select 1 from g_messagetagtable where tag_id = 8003 limit 1);
insert into g_messagetagtable select 8004,'HB' where
    not exists (select 1 from g_messagetagtable where tag_id = 8004 limit 1);
insert into g_messagetagtable select 8005,'WIDS' where
    not exists (select 1 from g_messagetagtable where tag_id = 8005 limit 1);
insert into g_messagetagtable select 8006,'DHCP' where
    not exists (select 1 from g_messagetagtable where tag_id = 8006 limit 1);

CREATE TABLE g_VersionTable (
   company          TEXT,
   major_number     INTEGER DEFAULT 1,
   minor_number     INTEGER DEFAULT 1,
   copyright        TEXT,
   install_time     TIMESTAMP DEFAULT (CURRENT_TIMESTAMP AT TIME ZONE 'UTC')
);

INSERT INTO g_VersionTable
    SELECT 'WatchGuard', 3, 20, 'Copyright: WatchGuard 2008-2015' WHERE
    NOT EXISTS (SELECT * from g_VersionTable LIMIT 1);

CREATE TABLE g_hostmap(
   appliance_id     INTEGER,
   ip               INET,
   fqdn             TEXT,
   resolve_time     TIMESTAMP, 
   expire_time      TIMESTAMP,
   UNIQUE(appliance_id, ip));

CREATE INDEX g_hostmap_appliance_id_idx ON g_hostmap(appliance_id);
CREATE INDEX g_hostmap_ip_idx ON g_hostmap(ip);
CREATE INDEX g_hostmap_resolve_time_idx ON g_hostmap(resolve_time);
CREATE INDEX g_hostmap_expire_time_idx ON g_hostmap(expire_time);

CREATE TABLE g_hostmap_static(
   appliance_id     INTEGER,
   ip               INET,
   fqdn             TEXT,
   resolve_time     TIMESTAMP, 
   expire_time      TIMESTAMP,
   UNIQUE(appliance_id, ip));

CREATE INDEX g_hostmap_static_appliance_id_idx ON g_hostmap(appliance_id);
CREATE INDEX g_hostmap_static_ip_idx ON g_hostmap(ip);
CREATE INDEX g_hostmap_static_resolve_time_idx ON g_hostmap(resolve_time);
CREATE INDEX g_hostmap_static_expire_time_idx ON g_hostmap(expire_time);
ALTER TABLE g_hostmap_static INHERIT g_hostmap;

CREATE TABLE g_HostMapTable(
   ip               INET,
   fqdn             VARCHAR(255),
   expire_time      TIMESTAMP,
   update_time      TIMESTAMP);

CREATE INDEX g_HostMapIndex_ip ON g_HostMapTable(ip);
CREATE INDEX g_HostMapIndex_expire_time ON g_HostMapTable(expire_time);
CREATE INDEX g_HostMapIndex_update_time ON g_HostMapTable(update_time);

CREATE TABLE g_ConfigureTable(
  maximum_storage   INTEGER DEFAULT 100,
  warning_limit     INTEGER DEFAULT 80,
  days_retain_log   INTEGER DEFAULT 30,
  days_backup_log   INTEGER DEFAULT 1,
  days_retain_audit INTEGER DEFAULT 365,
  backup_file_dir   TEXT,   
  backup_file_format TEXT DEFAULT 'CSV',   
  run_backup_time   TIME DEFAULT '02:30',
  run_backup_day    INTEGER DEFAULT 1,
  latest_backup_runtime TIMESTAMP,
  run_delete_time   TIME DEFAULT '02:30',
  run_delete_day    INTEGER DEFAULT 1,
  latest_delete_runtime TIMESTAMP,
  logserver_pause   INTEGER DEFAULT 0,
  notify_admin_flag INTEGER DEFAULT 0,
  smtp_login_flag   INTEGER DEFAULT 0,
  log_del_flag      INTEGER DEFAULT 0,
  show_schedule_flag INTEGER DEFAULT 0,
  backup_flag       INTEGER DEFAULT 0,
  show_backup_flag  INTEGER DEFAULT 0,
  appliance_notify_flag INTEGER DEFAULT 0,
  test_email_flag   INTEGER DEFAULT 0,
  delete_data_in_table INTEGER DEFAULT 0,
  notify_on_failure_flag INTEGER DEFAULT 0,
  dynamic_host_lookup_flag INTEGER DEFAULT 0,
  delete_log_by_age INTEGER DEFAULT -1
);
INSERT INTO g_ConfigureTable
    SELECT 100, 80, 30, 1, 365, 'c:/Documents and Settings/WatchGuard/wlogserver/tmp',
           'CSV','02:30', 1, NULL, '02:30', 1, NULL, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -1 WHERE
    NOT EXISTS (SELECT * from g_ConfigureTable LIMIT 1);

CREATE TABLE g_EmailTable(

  email_address     TEXT,
  email_host        TEXT,
  user_id           TEXT,
  password          TEXT,
  email_subject     TEXT,
  email_body        TEXT,
  from_address      TEXT,
  to_address        TEXT,
  update_time       TIMESTAMP DEFAULT (CURRENT_TIMESTAMP AT TIME ZONE 'UTC'),
  starttls_flag     INTEGER DEFAULT 0
);
INSERT INTO g_EmailTable
    SELECT '', 'localhost', NULL, NULL, 'WatchGuard Log Server Notification', 'WatchGuard Notification', 'wlogserver@localhost', 'admin@localhost' WHERE
    NOT EXISTS (SELECT * from g_EmailTable LIMIT 1);

CREATE TABLE g_sn_TimeTable (
   sn                 TEXT PRIMARY KEY,
   first_record_time  TIMESTAMP,
   last_record_time   TIMESTAMP
);

CREATE TABLE g_sn_CollectorTable (
   id                 SERIAL PRIMARY KEY,
   sn                 TEXT,
   collector_id       TEXT NOT NULL,
   update_time        TIMESTAMP DEFAULT date_trunc('second', clock_timestamp() AT TIME ZONE 'UTC')
);
CREATE INDEX g_sn_collectortable_sn_idx ON g_sn_collectortable (sn);
CREATE INDEX g_sn_collectortable_cid_idx ON g_sn_collectortable (collector_id);
CREATE INDEX g_sn_collectortable_ut_idx ON g_sn_collectortable (update_time);

CREATE TABLE g_partitiontable (
   segment_id         INTEGER NOT NULL,
   create_time        TIMESTAMP NOT NULL DEFAULT date_trunc('second', CURRENT_TIMESTAMP AT TIME ZONE 'UTC'),
   data_time          TIMESTAMP NOT NULL DEFAULT date_trunc('second', CURRENT_TIMESTAMP AT TIME ZONE 'UTC'),
   backup_status      INTEGER NOT NULL DEFAULT -1,
   backup_status_time TIMESTAMP NOT NULL DEFAULT date_trunc('second', CURRENT_TIMESTAMP AT TIME ZONE 'UTC')
) WITH (FILLFACTOR = 50);
CREATE INDEX g_partitiontable_ct_idx ON g_partitiontable(create_time);
CREATE INDEX g_partitiontable_dt_idx ON g_partitiontable(data_time);

CREATE TABLE g_log_collectors (
   id                 SERIAL PRIMARY KEY,
   collector_id       TEXT NOT NULL,
   ip                 TEXT NOT NULL DEFAULT host(inet_client_addr())::text,
   update_time        TIMESTAMP DEFAULT date_trunc('second', clock_timestamp() AT TIME ZONE 'UTC')
);
CREATE INDEX g_log_collectors_cid_idx ON g_log_collectors(collector_id);
CREATE INDEX g_log_collectors_ut_idx ON g_log_collectors(update_time);

CREATE TABLE g_appinfo (
   app_id       TEXT PRIMARY KEY,
   app_name     TEXT,
   app_cat_name TEXT);
CREATE INDEX g_appinfo_an_idx ON g_appinfo(app_name);
CREATE INDEX g_appinfo_acn_idx ON g_appinfo(app_cat_name);

CREATE TABLE g_ipsinfo (
   signature_id   TEXT PRIMARY KEY,
   signature_name TEXT,
   signature_cat  TEXT,
   severity       TEXT);
CREATE INDEX g_ipsinfo_sn_idx ON g_ipsinfo(signature_name);
CREATE INDEX g_ipsinfo_sc_idx ON g_ipsinfo(signature_cat);

CREATE TABLE g_wbinfo (
   cat_id         TEXT PRIMARY KEY,
   cat_name       TEXT);
CREATE INDEX g_wbinfo_cn_idx on g_wbinfo(cat_name);
CREATE SEQUENCE g_wbinfo_id_seq MINVALUE 100000;

CREATE TABLE g_dlpinfo (
   rule_id        TEXT PRIMARY KEY,
   rule_name      TEXT);
CREATE INDEX g_dlpinfo_rn_idx on g_dlpinfo(rule_name);
CREATE SEQUENCE g_dlpinfo_id_seq MINVALUE 1;

CREATE TABLE g_denyinfo (
   type_id        TEXT PRIMARY KEY,
   type_name      TEXT);
CREATE INDEX g_denyinfo_tn_idx on g_denyinfo(type_name);
CREATE SEQUENCE g_denyinfo_id_seq MINVALUE 1;

CREATE TABLE g_policyinfo (
   policy_id      TEXT PRIMARY KEY,
   policy_name    TEXT);
CREATE INDEX g_policyinfo_pn_idx on g_policyinfo(policy_name);
CREATE SEQUENCE g_policyinfo_id_seq MINVALUE 1;

CREATE TABLE g_aptinfo (
   apt_id         TEXT PRIMARY KEY,
   threat_uuid    TEXT NOT NULL,
   threat_md5     TEXT NOT NULL,
   threat_level   TEXT NOT NULL);
CREATE INDEX g_aptinfo_threat_uuid_idx ON g_aptinfo(threat_uuid);
CREATE INDEX g_aptinfo_threat_md5_idx ON g_aptinfo(threat_md5);
CREATE INDEX g_aptinfo_threat_level_idx ON g_aptinfo(threat_level);
CREATE SEQUENCE g_aptinfo_id_seq MINVALUE 1;
 
CREATE TABLE g_apt_classification (
   apt_id           TEXT NOT NULL,
   threat_class     TEXT,
   threat_name      TEXT,
   threat_score     TEXT,
   threat_mime_type TEXT);
ALTER TABLE g_apt_classification ADD CONSTRAINT g_apt_classification_apt_id_fkey FOREIGN KEY (apt_id) REFERENCES g_aptinfo(apt_id);
CREATE INDEX g_apt_classification_apt_id_idx ON g_apt_classification(apt_id);
CREATE INDEX g_apt_classification_threat_class_idx ON g_apt_classification(threat_class);
CREATE INDEX g_apt_classification_threat_name_idx ON g_apt_classification(threat_name);
CREATE INDEX g_apt_classification_threat_score_idx ON g_apt_classification(threat_score);
CREATE INDEX g_apt_classification_threat_mime_type_idx ON g_apt_classification(threat_mime_type);

CREATE TABLE g_apt_activity_info (
   activity_id    TEXT PRIMARY KEY,
   activity       TEXT);
CREATE sequence g_apt_activity_info_id_seq minvalue 1;

CREATE TABLE g_apt_activities (
   apt_id         TEXT NOT NULL,
   activity_id    TEXT NOT NULL);
ALTER TABLE g_apt_activities ADD CONSTRAINT g_apt_activities_apt_id_fkey FOREIGN KEY (apt_id) REFERENCES g_aptinfo(apt_id);
ALTER TABLE g_apt_activities ADD CONSTRAINT g_apt_activities_activity_id_fkey FOREIGN KEY (activity_id) REFERENCES g_apt_activity_info(activity_id);

CREATE TABLE apt_submissions(
   sn             TEXT NOT NULL,
   cluster        TEXT,
   apt_id         TEXT NOT NULL,
   start_time     TIMESTAMP, 
   end_time       TIMESTAMP);
CREATE INDEX apt_submissions_sn_idx ON apt_submissions(sn);
CREATE INDEX apt_submissions_cluster_idx ON apt_submissions(cluster);
CREATE INDEX apt_submissions_apt_id_idx ON apt_submissions(apt_id);
CREATE INDEX apt_submissions_start_time_idx ON apt_submissions(start_time);
CREATE INDEX apt_submissions_end_time_idx ON apt_submissions(end_time);

CREATE TABLE apt_submissions_0(
   sn             TEXT NOT NULL,
   cluster        TEXT,
   apt_id         TEXT NOT NULL,
   start_time     TIMESTAMP, 
   end_time       TIMESTAMP);
CREATE INDEX apt_submissions_0_sn_idx ON apt_submissions_0(sn);
CREATE INDEX apt_submissions_0_cluster_idx ON apt_submissions_0(cluster);
CREATE INDEX apt_submissions_0_apt_id_idx ON apt_submissions_0(apt_id);
CREATE INDEX apt_submissions_0_start_time_idx ON apt_submissions_0(start_time);
CREATE INDEX apt_submissions_0_end_time_idx ON apt_submissions_0(end_time);
ALTER TABLE apt_submissions_0 INHERIT apt_submissions;

CREATE SEQUENCE cluster_traffic_sid_seq MINVALUE 1 MAXVALUE 2147483647 CYCLE;
CREATE TABLE cluster_traffic(
   sid        INTEGER DEFAULT NEXTVAL('cluster_traffic_sid_seq'), 
   cluster    TEXT DEFAULT '', 
   sn         TEXT NOT NULL, 
   tag_id     INTEGER, 
   raw_id     BIGINT DEFAULT 0, 
   disp       SMALLINT, 
   direction  SMALLINT, 
   pri        SMALLINT, 
   policy     TEXT, 
   protocol   TEXT, 
   src_ip     TEXT, 
   src_port   INTEGER, 
   dst_ip     TEXT, 
   dst_port   INTEGER, 
   src_ip_nat TEXT, 
   src_port_nat INTEGER, 
   dst_ip_nat TEXT, 
   dst_port_nat INTEGER, 
   src_intf   TEXT, 
   dst_intf   TEXT, 
   rc         INTEGER, 
   pckt_len   INTEGER, 
   ttl        INTEGER, 
   pr_info    TEXT, 
   proxy_act  TEXT, 
   alarm_name TEXT, 
   alarm_type TEXT, 
   alarm_id   TEXT, 
   info_1     TEXT, 
   info_2     TEXT, 
   info_3     TEXT, 
   info_4     TEXT, 
   info_5     TEXT, 
   info_6     TEXT, 
   log_type   TEXT, 
   msg        TEXT, 
   bucket     TEXT, 
   update_time TIMESTAMP 
);
CREATE INDEX cluster_traffic_utm_idx ON cluster_traffic(update_time);
CREATE INDEX cluster_traffic_ut_idx ON cluster_traffic(sn, "cluster", update_time);
CREATE INDEX cluster_traffic_sip_idx ON cluster_traffic(src_ip);
CREATE INDEX cluster_traffic_sid_idx ON cluster_traffic(sid);

CREATE SEQUENCE cluster_status_sid_seq MINVALUE 1 MAXVALUE 2147483647 CYCLE;
CREATE TABLE cluster_status(
  sid        INTEGER DEFAULT NEXTVAL('cluster_status_sid_seq'), 
  cluster    TEXT DEFAULT '', 
  sn         TEXT NOT NULL, 
  tag_id     INTEGER, 
  raw_id     BIGINT DEFAULT 0, 
  pri        SMALLINT, 
  proc_id    TEXT, 
  msg_id     TEXT, 
  log_type   TEXT, 
  msg        TEXT, 
  update_time TIMESTAMP 
);
CREATE INDEX cluster_status_utm_idx ON cluster_status(update_time);
CREATE INDEX cluster_status_ut_idx ON cluster_status(sn, "cluster", update_time);
CREATE INDEX cluster_status_tid_idx ON cluster_status(tag_id) WHERE tag_id != 1002;

CREATE SEQUENCE cluster_pe_sid_seq MINVALUE 1 MAXVALUE 2147483647 CYCLE;
CREATE TABLE cluster_pe(
  sid        INTEGER DEFAULT NEXTVAL('cluster_pe_sid_seq'), 
  cluster    TEXT DEFAULT '', 
  sn         TEXT NOT NULL, 
  raw_id     BIGINT DEFAULT 0, 
  device     TEXT, 
  unix_time  TEXT, 
  in_octets  BIGINT, 
  out_octets BIGINT, 
  log_type   TEXT, 
  update_time TIMESTAMP 
);
CREATE INDEX cluster_pe_utm_idx ON cluster_pe(update_time);
CREATE INDEX cluster_pe_ut_idx ON cluster_pe(sn, "cluster", update_time);

CREATE SEQUENCE cluster_srv_sid_seq MINVALUE 1 MAXVALUE 2147483647 CYCLE;
CREATE TABLE cluster_srv(
   sid       INTEGER DEFAULT NEXTVAL('cluster_srv_sid_seq'),
   cluster   TEXT DEFAULT '', 
   sn        TEXT NOT NULL, 
   tag_id    INTEGER, 
   raw_id    BIGINT DEFAULT 0, 
   pri       SMALLINT, 
   conn_id   INTEGER, 
   req_id    INTEGER, 
   mc        INTEGER, 
   rc        INTEGER, 
   app       TEXT, 
   proc_id   TEXT, 
   msg       TEXT, 
   info_1    TEXT, 
   info_2    TEXT, 
   info_3    TEXT, 
   info_4    TEXT, 
  update_time TIMESTAMP 
);
CREATE INDEX cluster_srv_utm_idx ON cluster_srv(update_time);
CREATE INDEX cluster_srv_ut_idx ON cluster_srv(sn, "cluster", update_time);
CREATE INDEX cluster_srv_tid_idx ON cluster_srv(tag_id) WHERE tag_id in (2002, 2005, 2012, 2015);

CREATE TABLE cluster_pe_security(
   sid                     BIGSERIAL PRIMARY KEY,
   cluster                 TEXT,
   sn                      TEXT,
   raw_id                  BIGINT,
   unix_time               TEXT,
   dlp_allow               INTEGER,
   dlp_drop                INTEGER,
   dlp_quarantine          INTEGER,
   dlp_scanned             INTEGER,
   gav_drop                INTEGER,
   gav_notscanned          INTEGER,
   gav_scanned             INTEGER,
   ips_scanned             INTEGER,
   ips_detected            INTEGER,
   ips_prevented           INTEGER,
   red_bad                 INTEGER,
   red_good                INTEGER,
   red_inconclusive        INTEGER,
   spam_scanned            INTEGER,
   spam_drop               INTEGER,
   spam_tagged             INTEGER,
   spam_quarantined        INTEGER,
   log_type                TEXT,
   update_time             TIMESTAMP,
   apt_scanned             INTEGER,
   apt_prevented           INTEGER,
   apt_notified            INTEGER,
   apt_quarantined         INTEGER
);
CREATE INDEX cluster_pe_security_sn_idx ON cluster_pe_security(sn);
CREATE INDEX cluster_pe_security_cl_idx ON cluster_pe_security("cluster");
CREATE INDEX cluster_pe_security_ut_idx ON cluster_pe_security(update_time);

CREATE SEQUENCE cluster_audit_sid_seq MINVALUE 1 MAXVALUE 2147483647 CYCLE;
CREATE SEQUENCE cluster_audit_import_seq START WITH 3;
CREATE TABLE cluster_audit(
   sid                INTEGER NOT NULL DEFAULT NEXTVAL('cluster_audit_sid_seq'), 
   cluster            TEXT DEFAULT '', 
   sn                 TEXT NOT NULL, 
   total_count_period INTEGER, 
   lt_tr_count_period INTEGER, 
   lt_db_count_period INTEGER, 
   lt_ev_count_period INTEGER, 
   lt_al_count_period INTEGER, 
   lt_pe_count_period INTEGER, 
   lt_se_count_period INTEGER DEFAULT 0,
   updated            INTEGER DEFAULT 0,
   update_time        TIMESTAMP,
   segment_date       DATE,
   segment_id         TEXT
);
ALTER TABLE cluster_audit ADD CONSTRAINT cluster_audit_pkey PRIMARY KEY (sid, sn);
CREATE INDEX cluster_audit_sn_idx ON cluster_audit (sn);
CREATE INDEX cluster_audit_ut_idx ON cluster_audit (update_time);

CREATE TABLE cluster_diag_audit(
   sid                INTEGER NOT NULL DEFAULT NEXTVAL('cluster_audit_sid_seq'), 
   cluster            TEXT DEFAULT '', 
   sn                 TEXT NOT NULL, 
   total_count_period INTEGER, 
   lt_tr_count_period INTEGER, 
   lt_db_count_period INTEGER, 
   lt_ev_count_period INTEGER, 
   lt_al_count_period INTEGER, 
   lt_pe_count_period INTEGER, 
   lt_se_count_period INTEGER DEFAULT 0,
   updated            INTEGER DEFAULT 0,
   update_time        TIMESTAMP,
   segment_date       DATE,
   segment_id         TEXT
);
ALTER TABLE cluster_diag_audit ADD CONSTRAINT cluster_diag_audit_pkey PRIMARY KEY (sid, sn);
CREATE INDEX cluster_diag_audit_sn_idx ON cluster_diag_audit (sn);
CREATE INDEX cluster_diag_audit_ut_idx ON cluster_diag_audit (update_time);
ALTER TABLE cluster_diag_audit INHERIT cluster_audit;

CREATE TABLE summary_traffic(
   sid            BIGSERIAL PRIMARY KEY,
   cluster        TEXT, 
   sn             TEXT NOT NULL, 
   tag_id         INTEGER, 
   src_ip         TEXT, 
   dst_ip         TEXT, 
   dst_port       INTEGER, 
   protocol       TEXT,
   src_intf       TEXT,
   dst_intf       TEXT,
   disp           SMALLINT,
   rcvd_bytes     BIGINT,
   sent_bytes     BIGINT,
   duration       INTEGER,
   count          INTEGER,
   start_time     TIMESTAMP,
   policy_id      TEXT,
   src_user       TEXT,
   dst_domain     TEXT,
   app_id         TEXT,
   signature_id   TEXT,
   deny_type_id   TEXT,
   reputation     TEXT,
   wb_cat_id      TEXT,
   alarm_name     TEXT,
   virus          TEXT,
   sender         TEXT,
   recipients     TEXT,
   host           TEXT,
   dlp_rule_id    TEXT,
   spam_type      TEXT,
   spam_action    TEXT,
   apt_id         TEXT,
   content_name   TEXT,
   quota_limit    TEXT
);
CREATE INDEX summary_traffic_sn_idx ON summary_traffic(sn);
CREATE INDEX summary_traffic_cl_idx ON summary_traffic("cluster") WHERE "cluster" IS NOT NULL;
CREATE INDEX summary_traffic_st_idx ON summary_traffic(start_time, tag_id);
CREATE INDEX summary_traffic_dip_idx ON summary_traffic(dst_ip);
CREATE INDEX summary_traffic_sip_idx ON summary_traffic(src_ip);
CREATE INDEX summary_traffic_su_idx ON summary_traffic(src_user) WHERE src_user IS NOT NULL;
CREATE INDEX summary_traffic_appid_idx ON summary_traffic(app_id) WHERE app_id IS NOT NULL;
CREATE INDEX summary_traffic_dlpid_idx ON summary_traffic(dlp_rule_id) WHERE dlp_rule_id IS NOT NULL;
CREATE INDEX summary_traffic_sigid_idx ON summary_traffic(signature_id) WHERE signature_id IS NOT NULL;
CREATE INDEX summary_traffic_wbid_idx ON summary_traffic(wb_cat_id) WHERE wb_cat_id IS NOT NULL;
CREATE INDEX summary_traffic_spam_idx ON summary_traffic(spam_type) WHERE spam_type IS NOT NULL;
CREATE INDEX summary_traffic_aptid_idx ON summary_traffic(apt_id) WHERE apt_id IS NOT NULL;
CREATE INDEX summary_traffic_content_name_idx ON summary_traffic(content_name) WHERE content_name IS NOT NULL;
CREATE INDEX summary_traffic_quota_limit_idx ON summary_traffic(quota_limit) WHERE quota_limit IS NOT NULL;

CREATE TABLE summary_audit(
   sid                     BIGSERIAL PRIMARY KEY,
   sn                      TEXT NOT NULL,
   cluster                 TEXT,
   begin_period            TIMESTAMP NOT NULL,
   rt_count_total          INTEGER,
   rt_count_pf             INTEGER,
   rt_count_px             INTEGER,
   rt_count_wb             INTEGER,
   rt_count_wb_allow       INTEGER,
   rt_count_http           INTEGER,
   rt_count_https          INTEGER,
   rt_count_smtp           INTEGER,
   rt_count_pop3           INTEGER,
   rt_count_ftp            INTEGER,
   rt_count_ips            INTEGER,
   rt_count_av             INTEGER,
   rt_count_app            INTEGER,
   rt_count_app_block      INTEGER,
   rt_count_red            INTEGER,
   rt_count_alarm          INTEGER,
   rt_count_deny           INTEGER,
   rt_count_pe             INTEGER,
   rt_count_dlp            INTEGER,
   rt_count_spam           INTEGER,
   rt_count_apt            INTEGER,
   rt_count_audit          INTEGER,
   rt_count_auth           INTEGER,
   rt_count_wids           INTEGER,
   rt_count_dhcp           INTEGER,
   rt_count_quota          INTEGER,
   segment_date            DATE,
   segment_id              TEXT
);
CREATE INDEX summary_audit_sn_idx ON summary_audit (sn);
CREATE INDEX summary_audit_cl_idx ON summary_audit ("cluster");
CREATE INDEX summary_audit_bp_idx ON summary_audit (begin_period);

CREATE TABLE connectwise_server_config(
   server_id               SERIAL PRIMARY KEY,
   enabled                 INTEGER,
   server_name             TEXT,
   timezone                TEXT,
   server_creds            TEXT,
   company_id              TEXT,
   ca_certificate          TEXT
);

CREATE TABLE connectwise_company_config(
   company_num             SERIAL PRIMARY KEY, 
   company_name            TEXT,
   solution_name           TEXT
);

CREATE TABLE ftp_server_config(
   server_id             SERIAL PRIMARY KEY,
   server_name           TEXT NOT NULL,
   upload_location       TEXT DEFAULT '',
   server_creds          TEXT,
   CONSTRAINT fc UNIQUE(server_name, upload_location)
);

CREATE SEQUENCE scheduled_tasks_sid_seq MINVALUE 1 MAXVALUE 2147483647 CYCLE;
CREATE TABLE scheduled_tasks(
   task_id                INTEGER DEFAULT NEXTVAL('scheduled_tasks_sid_seq') PRIMARY KEY,
   task_type              TEXT NOT NULL,
   task_name              TEXT UNIQUE,
   description            TEXT DEFAULT '',
   run_interval           INTERVAL DEFAULT '0 days',
   notify_admin           BOOLEAN NOT NULL DEFAULT FALSE,
   task_status            INTEGER NOT NULL DEFAULT 0,
   task_progress          INTEGER NOT NULL DEFAULT 0,
   fail_times             INTEGER NOT NULL DEFAULT 0,
   last_failure           TEXT NOT NULL DEFAULT '',
   next_run_time          TIMESTAMP NOT NULL,
   start_run_time         TIMESTAMP,
   last_update_time       TIMESTAMP,
   end_run_time           TIMESTAMP,
   task_modify_time       TIMESTAMP,
   task_create_time       TIMESTAMP NOT NULL,
   task_creator           TEXT
) WITH(FILLFACTOR = 50);
CREATE INDEX scheduled_tasks_tn_idx ON scheduled_tasks(task_name);
CREATE INDEX scheduled_tasks_nrt_idx ON scheduled_tasks(next_run_time);

CREATE TABLE report_tasks_detail(
   task_id                INTEGER REFERENCES scheduled_tasks(task_id) ON DELETE CASCADE,
   task_type              TEXT DEFAULT 'report' CHECK(task_type = 'report'),
   appliances             INTEGER[] NOT NULL,
   report_types           INTEGER[] NOT NULL,
   data_begin_time        TIMESTAMP,
   data_end_time          TIMESTAMP,
   aggregate              TEXT NOT NULL,
   tzname                 TEXT NOT NULL,
   customization_name     TEXT,
   report_types_remaining INTEGER[],
   report_types_success   INTEGER[],
   file_target            INTEGER REFERENCES ftp_server_config(server_id) INITIALLY DEFERRED,
   file_location          TEXT,
   connectwise_target     INTEGER REFERENCES connectwise_company_config(company_num) INITIALLY DEFERRED,
   email_targets          TEXT[],
   email_subject          TEXT,
   email_body             TEXT
) WITH(FILLFACTOR = 50);
CREATE INDEX report_tasks_detail_tid_idx ON report_tasks_detail(task_id);

CREATE TABLE segment_tasks_detail(
   task_id                INTEGER REFERENCES scheduled_tasks(task_id) ON DELETE CASCADE,
   task_type              TEXT NOT NULL,
   data_begin_time        TIMESTAMP NOT NULL,
   data_end_time          TIMESTAMP,
   segments               TEXT[],
   segments_success       TEXT[],
   segments_remaining     TEXT[]
) WITH(FILLFACTOR = 50);
CREATE INDEX segment_tasks_detail_tid_idx ON segment_tasks_detail(task_id);

CREATE TABLE report_customization(
   customization_name      TEXT PRIMARY KEY,
   header                  TEXT,
   footer                  TEXT,
   logo                    BYTEA,
   is_default              BOOLEAN,
   paper_size              INTEGER NOT NULL DEFAULT 0
);

CREATE TABLE g_modelinfo(
   model_name_short        TEXT,
   model_name              TEXT
);
