/*global  checkLoginPageRedirect,createRsSingleGrid,colSpokeNames,colSpokeModel,manage_vpn_perm,WG_VPNMAP,VPN_WIZARD,S_VPN_SAVE_VPN_MSG,S_VPN_SAVE_VPN_APPLY_MSG,S_VPN_SAVE_VPN_SUCCESS_MSG,UpdateDeviceObj,SpokeObj,S_VPN_VIF_BOVPN,S_VPN_TRADITIONAL_BOVPN,S_VPN_SPOKES,S_VPN_SPOKES_SINGULAR,S_VPN_EDIT_HUB_BTN,S_VPNMAP_LAST_UPDATE,S_VPN_REM_ERROR,S_VPN_REM_ERROR_CONFIRM,S_VPN_REFRESH_ERROR,S_X_OF_Y,S_VPN_DIMENSION,S_VPN_DEL_VPN_MSG_1,S_VPN_DEL_VPN_MSG_1_COMPLETE,S_VPN_DEL_VPN_MSG_2,S_VPN_DEL_VPN_MSG_2_COMPLETE,S_VPN_DEL_VPN_MSG_3,S_VPN_DEL_VPN_MSG_3_COMPLETE,S_VPN_TUNNEL_MODES*/
var CONTROL_VPN = {
    urlSn: '',
    tid: null,
    updateTimeout: 300000,
    updateTid: null,
    loading: true,
    hub_error_state: false,
    managed_vpn_obj: null,
    spokes_obj: null,
    sel_row: -1,
    init: function () {
        $.getUrlVars();
        CONTROL_VPN.urlSn = $.getUrlVar('sn');
        CONTROL_VPN.initUI();
        CONTROL_VPN.initEvents();

        if (isNaN(parseInt(CONTROL_VPN.urlSn, 10))) {
            VPN_WIZARD.showVpnDialog('hub', 'add');
            CONTROL_VPN.loading = false;
            CONTROL_VPN.uiState();
        } else {
            CONTROL_VPN.getData();
        }
    },

    initUI: function () {
        createRsSingleGrid(colSpokeNames, colSpokeModel, "#grid_spoke", { pager: '#grid_spoke_pager', rowNum: 10, rowList: [10, 20, 50, 100], viewrecords: true, pagerpos: 'right', recordpos: 'left'});
        $("#grid_spoke").navGrid("#grid_spoke_pager", { refresh: false, search: false, edit: false, add: false, del: false }, {}, { width: 350 }, {});
        $("#grid_spoke").click(CONTROL_VPN.uiState);

        WGRD.showUIElements(!manage_vpn_perm, ['#btn_view_spoke']);
        WGRD.showUIElements(manage_vpn_perm, ['#btn_add_spoke', '#btn_edit_spoke', '#btn_rem_spoke']);

        CONTROL_VPN.uiState();
        if (CONTROL_VPN.urlSn) {
            CONTROL_VPN.updateTid = setTimeout(CONTROL_VPN.getData, CONTROL_VPN.updateTimeout);
        }
    },

    initEvents: function () {

        $("#btn_edit_hub").on('click', CONTROL_VPN.editHub);

        $("#btn_add_spoke").on('click', CONTROL_VPN.addSpoke);
        $("#btn_edit_spoke").click(CONTROL_VPN.editSpoke);
        $("#btn_view_spoke").click(CONTROL_VPN.viewSpoke);
        $("#btn_rem_spoke").click(CONTROL_VPN.remSpoke);

        $("#btn_vpn_refresh").click(CONTROL_VPN.refreshHealth);

        $('#spoke_confirm_save_btn').click(function () {
            $('#spoke_confirm_dlg').modal("hide");
            CONTROL_VPN._remSpoke();
        });

        $(document).on('click', '#vpnmap_edit_spoke', function (eo) {
            if (WG_VPNMAP.popover_spoke_id) {
                var action = 'edit';
                if ($("#btn_view_spoke").is(':visible')) {
                    action = 'view';
                }
                CONTROL_VPN._editviewSpoke(WG_VPNMAP.popover_spoke_id, action);
            }
        });

        $("#vpn_save_progress_no").on('click', function (eo) {
            $("#vpn_save_progress").modal('hide');
        });

        $(window).bind('resizeEnd', function () {
            CONTROL_VPN.doResize();
        });
    },
    editHub: function (eo) {
        //var resource_list = CONTROL_VPN.managed_vpn_obj.hub_gateways[0].resource_list;
        var obj = { 'use_vif': CONTROL_VPN.managed_vpn_obj.properties.use_vif, 'hub_resource_list': CONTROL_VPN.managed_vpn_obj.hub_gateways[0].resource_list, 'managed_vpn_obj': CONTROL_VPN.managed_vpn_obj, 'hub_device_name': CONTROL_VPN.managed_vpn_obj.hub_device.appliance_name };
        VPN_WIZARD.showVpnDialog('hub', 'edit', CONTROL_VPN.urlSn, obj, CONTROL_VPN.refreshHealth);
        return;
    },
    addSpoke: function (eo) {
        var virtual_ip = CONTROL_VPN.managed_vpn_obj.hub_gateways[0].virtual_ip || '';
        var obj = { 'use_vif': CONTROL_VPN.managed_vpn_obj.properties.use_vif, 'virtual_ip': virtual_ip, 'hub_resource_list': CONTROL_VPN.managed_vpn_obj.hub_gateways[0].resource_list, 'hub_device_name': CONTROL_VPN.managed_vpn_obj.hub_device.appliance_name };
        VPN_WIZARD.showVpnDialog('spoke', 'add', CONTROL_VPN.urlSn, obj, CONTROL_VPN.refreshHealthTimer20s);
    },
    viewSpoke: function (eo) {
        var value = $('#grid_spoke').jqGrid('getGridParam', 'selrow');
        if (!value) {
            return;
        }
        var sel_row = parseInt(value, 10);
        var spoke_id = $('#grid_spoke').jqGrid('getCell', sel_row, 'spoke_id');

        return CONTROL_VPN._editviewSpoke(parseInt(spoke_id, 10), 'view');
    },
    _editviewSpoke: function (spoke_id, action, spoke_name) {
        var spoke_obj = {};
        var spokes = CONTROL_VPN.spokes_obj;
        var i = 0;
        for (i = 0; i < spokes.length; i++) {
            if (spokes[i].id === spoke_id) {
                spoke_obj = spokes[i];
                if (spoke_name) {
                    // only used for 'edit' action
                    spoke_obj.name = spoke_name;
                }
            }
        }
        if (spoke_obj) {
            var resource_list = CONTROL_VPN.managed_vpn_obj.hub_gateways[0].resource_list;
            var virtual_ip = CONTROL_VPN.managed_vpn_obj.hub_gateways[0].virtual_ip || '';
            var obj = { 'use_vif': CONTROL_VPN.managed_vpn_obj.properties.use_vif, 'virtual_ip': virtual_ip, 'hub_resource_list': resource_list, 'spoke_obj': spoke_obj, 'hub_device_name': CONTROL_VPN.managed_vpn_obj.hub_device.appliance_name };
            VPN_WIZARD.showVpnDialog('spoke', action, CONTROL_VPN.urlSn, obj, CONTROL_VPN.refreshHealthTimer20s);
        }
    },
    editSpoke: function (eo) {
        var value = $('#grid_spoke').jqGrid('getGridParam', 'selrow');
        if (!value) {
            return;
        }
        var sel_row = parseInt(value, 10);
        var spoke_id = $('#grid_spoke').jqGrid('getCell', sel_row, 'spoke_id');
        var spoke_name = $('#grid_spoke').jqGrid('getCell', sel_row, 'name_disp');

        return CONTROL_VPN._editviewSpoke(parseInt(spoke_id, 10), 'edit', spoke_name);
    },
    remSpoke: function (eo) {
        var sel_row = $('#vpns_table').jqGrid('getGridParam', 'selrow');
        if (sel_row === null) {
            return;
        }
        $("#spoke_confirm_dlg").modal();
    },
    _getSpokeUpdateObj: function (type) {
        var sel_row = CONTROL_VPN.getCurSel();
        var device_id = $('#grid_spoke').jqGrid('getCell', sel_row, 'device_id');
        var gateway_id = $('#grid_spoke').jqGrid('getCell', sel_row, 'spoke_id');

        var update_device_obj = new UpdateDeviceObj();
        update_device_obj.action = 1; // delete
        update_device_obj.spoke_device_id = parseInt(device_id, 10);
        update_device_obj.spoke_id = parseInt(gateway_id, 10);
        update_device_obj.vpn_id = parseInt(CONTROL_VPN.urlSn, 10);
        update_device_obj.apply_device = type;

        return update_device_obj;
    },
    _remSpoke: function () {
        $("#vpn_save_progress").modal({ backdrop: 'static', keyboard: false });
        $("#vpn_save_progress_close, #vpn_save_progress .close").off('click');
        $("#vpn_save_progress_close, #vpn_save_progress .close").on('click', function (eo) {
            $("#vpn_save_progress").modal('hide');
        });
        WGRD.enableUIElements(false, ['#remove_vpn']);

        //Delete spoke device configuration
        var sel_row = CONTROL_VPN.getCurSel();
        var spoke_name = $('#grid_spoke').jqGrid('getCell', sel_row, 'name_disp');
        VPN_WIZARD.uiInitProgress(spoke_name, CONTROL_VPN.managed_vpn_obj.hub_device.appliance_name, S_VPN_DIMENSION);
        VPN_WIZARD.uiStateProgress('loading', 1, S_VPN_DEL_VPN_MSG_1);
        var update_device_obj = CONTROL_VPN._getSpokeUpdateObj('spoke');
        WGRD.putData(update_device_obj).success(function (response) {
            var message = '';
            if (!response.status) {
                VPN_WIZARD.uiStateProgress('failure', 1, response.message);
                message = response.message;
            } else {
                VPN_WIZARD.uiStateProgress('complete', 1, S_VPN_DEL_VPN_MSG_1_COMPLETE);
            }
            CONTROL_VPN._remSpokeContinue(update_device_obj.spoke_id, sel_row, 'spoke', message);
        });

        setTimeout(CONTROL_VPN._remHubSettings, 200);
        return false;
    },
    _remHubSettings: function () {
        //Delete hub device configuration
        var sel_row = CONTROL_VPN.getCurSel();
        var update_device_obj = CONTROL_VPN._getSpokeUpdateObj('hub');
        VPN_WIZARD.uiStateProgress('loading', 2, S_VPN_DEL_VPN_MSG_2);
        WGRD.putData(update_device_obj).success(function (response) {
            var message = '';
            if (!response.status) {
                VPN_WIZARD.uiStateProgress('failure', 2, response.message);
                message = response.message;
            } else {
                VPN_WIZARD.uiStateProgress('complete', 2, S_VPN_DEL_VPN_MSG_2_COMPLETE);
            }
            CONTROL_VPN._remSpokeContinue(update_device_obj.spoke_id, sel_row, 'hub', message);
        });
    },
    _remSpokeContinue: function (id, sel_row, type, message) {
        if (VPN_WIZARD.progressTotal < 2) {
            return;
        }
        if (VPN_WIZARD.progressComplete < VPN_WIZARD.progressTotal) {
            CONTROL_VPN._remSpokeError(id, sel_row, type, message);
        } else {
            CONTROL_VPN._remSpokeDB(id, sel_row);
        }
    },
    _remSpokeError: function (gateway_id, sel_row, type, message) {
        WGRD.showUIElements(true, ["#vpn_save_progress_yes, #vpn_save_progress_no"]);
        WGRD.showUIElements(false, ["#vpn_save_progress_close"]);
        $("#vpn_save_progress_text").text(S_VPN_REM_ERROR);

        $("#vpn_save_progress_yes").off('click');
        $("#vpn_save_progress_yes").on('click', function (eo) {
            CONTROL_VPN._remSpokeDB(gateway_id, sel_row);
        });
    },
    _remSpokeDB: function (id, sel_row) {
        var spoke_obj = new SpokeObj();
        spoke_obj.action = 1; // delete
        spoke_obj.id = parseInt(id, 10);
        spoke_obj.name = $('#grid_spoke').jqGrid('getCell', sel_row, 'name_disp');
        spoke_obj.managed_vpn_id = parseInt(CONTROL_VPN.urlSn, 10);

        //Delete Spoke
        VPN_WIZARD.uiStateProgress('loading', 3, S_VPN_DEL_VPN_MSG_3);
        WGRD.putData(spoke_obj).success(function (response) {
            if (!response.status) {
                VPN_WIZARD.uiStateProgress('failure', 3, response.message);
            } else {
                VPN_WIZARD.uiStateProgress('complete', 3, S_VPN_DEL_VPN_MSG_3_COMPLETE);
                $('#grid_spoke').jqGrid('delRowData', sel_row);
                CONTROL_VPN.getData();
            }
        });
        return false;
    },
    uiState: function () {
        WGRD.enableUIElements(true, ['#btn_add_spoke', '#btn_edit_hub', '#btn_vpn_refresh']);
        WGRD.showUIElements(false, ['#vpn_loading_spinner']);
        if (CONTROL_VPN.loading) {
            WGRD.enableUIElements(false, ['#btn_add_spoke', '#btn_edit_hub', '#btn_vpn_refresh']);
            WGRD.showUIElements(true, ['#vpn_loading_spinner']);
        }

        WGRD.enableUIElements(false, ['#btn_edit_spoke', '#btn_rem_spoke', '#btn_view_spoke']);

        var selrow = $('#grid_spoke').jqGrid('getGridParam', 'selrow');
        if (selrow) {
            WGRD.enableUIElements(true, ['#btn_edit_spoke', '#btn_rem_spoke', '#btn_view_spoke']);
        }

        $("#vpn_error").hide();
        if (CONTROL_VPN.hub_error_state) {
            WGRD.enableUIElements(false, ['#btn_add_spoke', '#btn_edit_spoke', '#btn_rem_spoke', '#btn_view_spoke']);
            $("#vpn_error").show();
        }
    },
    refreshHealthTimer20s: function (eo) {
        clearTimeout(CONTROL_VPN.updateTid);
        CONTROL_VPN.getData();
        CONTROL_VPN.updateTid = setTimeout(CONTROL_VPN.refreshHealth, 20000);
    },
    refreshHealth: function (eo) {
        if (!CONTROL_VPN.urlSn) {
            return;
        }
        var url = "refresh_health?vpn_id=" + CONTROL_VPN.urlSn;
        clearTimeout(CONTROL_VPN.updateTid);
        CONTROL_VPN.loading = true;
        CONTROL_VPN.uiState();
        $.ajax({
            url: url,
            method: 'GET',
            dataType: 'json',
            error: function (xhr, status, error) {
                checkLoginPageRedirect(xhr, status, error);
            },
            success: function (data) {
                if (data.status === false) {
                    WGRD.okMessageModal(S_VPN_REFRESH_ERROR.format(data.message), '');
                    CONTROL_VPN.loading = false;
                    CONTROL_VPN.uiState();
                    return;
                }
                setTimeout(CONTROL_VPN.getData, 1000);
            }
        });
    },
    getCurSel: function () {
        var value = $('#grid_spoke').jqGrid('getGridParam', 'selrow');
        if (!value) {
            return -1;
        }
        return parseInt(value, 10);
    },
    getData: function () {
        clearTimeout(CONTROL_VPN.updateTid);
        var url = "get_vpn?sn=" + CONTROL_VPN.urlSn;
        CONTROL_VPN.sel_row = CONTROL_VPN.getCurSel();
        CONTROL_VPN.loading = true;
        CONTROL_VPN.uiState();
        $.ajax({
            url: url,
            method: 'GET',
            dataType: 'json',
            error: function (xhr, status, error) {
                checkLoginPageRedirect(xhr, status, error);
            },
            success: CONTROL_VPN.redraw,
            complete: function (data) {
                CONTROL_VPN.loading = false;
                CONTROL_VPN.uiState();
                CONTROL_VPN.updateTid = setTimeout(CONTROL_VPN.getData, CONTROL_VPN.updateTimeout);
            }
        });
    },
    redraw: function (data) {
        if (!data.status) {
            window.location = '/';
        }
        CONTROL_VPN.hub_error_state = false;
        if (data.hub_error) {
            CONTROL_VPN.hub_error_state = true;
            $("#vpn_error").text(data.hub_error_message);
        }
        var links = [];
        var cloud_idx = 0;
        var device_idx = 1;
        for (device_idx = 1; device_idx < data.nodes.length; device_idx++) {
            links.push({ 'source': cloud_idx, 'target': device_idx, 'name': data.nodes[device_idx].name });
        }
        $('#grid_spoke').jqGrid('clearGridData');

        CONTROL_VPN.managed_vpn_obj = data.managed_vpn;
        CONTROL_VPN.spokes_obj = data.spokes;

        var list = [];
        var title = data.managed_vpn.properties.name;
        $("#breadcrumbName").text(title);
        if (data.managed_vpn.properties.use_vif) {
            list.push(S_VPN_VIF_BOVPN);
        } else {
            list.push(S_VPN_TRADITIONAL_BOVPN);
        }
        var spokestr = S_VPN_SPOKES.format(data.managed_vpn.spoke_count);
        if (data.managed_vpn.spoke_count === 1) {
            spokestr = S_VPN_SPOKES_SINGULAR.format(data.managed_vpn.spoke_count);
        }
        list.push(spokestr);

        var vpn_health_time = '';
        if (data.managed_vpn.hub_device.hasOwnProperty('vpn_health_time')) {
            vpn_health_time = $.getDateDisplay(data.managed_vpn.hub_device.vpn_health_time + " GMT");
            vpn_health_time = S_VPNMAP_LAST_UPDATE.format(vpn_health_time);
        }
        var legend = { 'title': title, 'button_callback': CONTROL_VPN.editHub, 'button_text': S_VPN_EDIT_HUB_BTN, 'list': list, 'vpn_health_time': vpn_health_time };
        WG_VPNMAP.update(data.nodes, links, legend);

        var i = 0;
        var j = 0;
        var spoke = {};
        var resources = '';
        var hub_resources = '';
        var interfaces = '';
        var grid_data = [];
        var obj = {};
        var tunnel_disp = '';
        var tunnel_mode = '';
        for (i = 0; i < data.spokes.length; i++) {
            spoke = data.spokes[i];
            resources = '';
            for (j = 0; j < spoke.resource_list.length; j++) {
                if (resources.length > 0) {
                    resources += ", ";
                }
                resources += VPN_WIZARD._getResourceDisplay(spoke.resource_list[j], data.managed_vpn.properties.use_vif);
            }
            interfaces = '';
            for (j = 0; j < spoke.ifname_list.length; j++) {
                if (interfaces.length > 0) {
                    interfaces += ", ";
                }
                interfaces += spoke.ifname_list[j];
            }
            hub_resources = '';
            switch (spoke.tunnel_mode) {
            case 0:
                for (j = 0; j < data.managed_vpn.hub_gateways[0].resource_list.length; j++) {
                    if (spoke.routing_list.indexOf(data.managed_vpn.hub_gateways[0].resource_list[j].id) >= 0) {
                        if (hub_resources.length > 0) {
                            hub_resources += ", ";
                        }
                        hub_resources += VPN_WIZARD._getResourceDisplay(data.managed_vpn.hub_gateways[0].resource_list[j], data.managed_vpn.properties.use_vif);
                    }
                }
                break;
            case 1:
                hub_resources = '0.0.0.0/0';
                break;
            case 2:
                resources = spoke.virtual_ip;
                hub_resources = data.managed_vpn.hub_gateways[0].virtual_ip;
                break;
            }
            tunnel_mode = S_VPN_TUNNEL_MODES[spoke.tunnel_mode];

            tunnel_disp = "0";
            if (spoke.total_tunnel_num > 0) {
                tunnel_disp = S_X_OF_Y.format(spoke.active_tunnel_num, spoke.total_tunnel_num);
            }

            obj = {
                'name': spoke.name,
                'name_disp': spoke.name_disp,
                'active_tunnel_num': tunnel_disp,
                'tunnel_mode': tunnel_mode,
                'vpn_resources': resources,
                'hub_resources': hub_resources,
                'interfaces': interfaces,
                'tunnel_switching': spoke.tunnel_switching,
                'policy_disp': spoke.policy_disp,
                'device_id': spoke.device_id,
                'spoke_id': spoke.id
            };
            grid_data.push(obj);
        }

        $('#grid_spoke').setGridParam({
            data: grid_data
        }).trigger("reloadGrid");

        if (CONTROL_VPN.sel_row !== -1) {
            $('#grid_spoke').jqGrid('setSelection', CONTROL_VPN.sel_row);
        }
        CONTROL_VPN.doResize();
    },
    doResize: function () {
        CONTROL_VPN.resizeGrids();
    },
    resizeGrids: function () {
        $('#grid_spoke').setGridWidth(100, true);
        $('#grid_spoke').setGridWidth($('#grid_spoke_wrapper').width(), true);
    }
};
$(document).ready(CONTROL_VPN.init);
