/*global escapeHtml,S_VPN_HUB_DEVICE,S_VPN_HUB_AND_SPOKE,manage_vpn_perm,S_VPNMAP_NODATA,S_VPNMAP_TOTAL_TUNNELS,S_VPNMAP_ACTIVE_TUNNELS,S_VPNMAP_TOTAL_SENT,S_VPNMAP_TOTAL_RECEIVED,S_VPNMAP_OPEN_WEBUI,S_VPNMAP_OPEN_WEBUI_VPNSTATISTICS, S_VPNMAP_EDIT_SPOKE*/
var WG_VPNMAP = {
    w: 120,
    h: 350,
    nodeType: 0,
    clrWgrdRed: '#f84529',
    clrWgrdGrn: '#4aab53',
    clrWgrdGry: '#999',
    bRunning: true,
    force: null,
    vis: null,
    isdrag: false,
    linkPath: null,
    nodePath: null,
    lastNodes: null,
    nodeWidth: 14,
    nodeHeight: 14,
    hubnodeHeight: 14.5,
    linkStrokeWidth: "1.2px",
    mousePos: [0, 0],
    nodes: [],
    nodeThresholds: [25, 50, 100],
    webui_link_path: '/dashboard/system?report=bovpn',
    popover_spoke_id: null,
    init: function () {
        WG_VPNMAP.w = $("#chart").width();

        WG_VPNMAP.initUI();
        WG_VPNMAP.initEvents();
    },
    initUI: function () {
        WG_VPNMAP.vis = d3.select("#chart")
            .append("svg:svg")
            .attr("width", WG_VPNMAP.w)
            .attr("height", WG_VPNMAP.h);

        WG_VPNMAP.force = d3.layout.force()
            .gravity(0.1)
            .charge(-420)
            .chargeDistance(WG_VPNMAP.w / 2)
            .on("tick", WG_VPNMAP.tick)
            .on("end", function (d) {
                WG_VPNMAP.bRunning = false;
            })
            .linkDistance(WG_VPNMAP.getLinkDistance)
            .size([WG_VPNMAP.w, WG_VPNMAP.h]);

        $(window).bind('resizeEnd', function () {
            WG_VPNMAP.doResize();
        });
    },
    initEvents: function () {
        $("body").mousemove(function (eo) {
            WG_VPNMAP.mousePos = [eo.pageX, eo.pageY];
        });

        // Close popup
        $(document).keyup(function (eo) {
            if (eo.keyCode === 27) {
                $("#cxn_popup").hide();
            }
        });
        $(document).on('click', '#cxn_popup .close', function (eo) {
            $("#cxn_popup").hide();
        });
    },
    tick: function (d) {
        WG_VPNMAP.linkPath
            .attr("d", WG_VPNMAP.drawLinkPath);

        // FIXME: Using global from the json file
        var hub = WG_VPNMAP.nodes[0];

        // Move the nodes and adjust text layout
        WG_VPNMAP.nodePath
            .attr("transform", function (d) {
                return "translate(" + parseInt(d.x, 10) + "," + parseInt(d.y, 10) + ")";
            })
            .selectAll(".nodetext")
            .attr("text-anchor", function (d) {
                if (d.type !== 'hub' && d.x < hub.x) {
                    return 'end';
                }
                return 'start';
            })
            .attr("y", function (d) {
                if (d.type === 'hub') {
                    return WG_VPNMAP.hubnodeHeight / 4;
                }
                if (d.y - hub.y > 50) {
                    return 18;
                }
                return 4;
            })
            .attr("dx", function (d) {
                if (d.type === 'hub') {
                    return WG_VPNMAP.hubnodeHeight;
                }
                if (d.x < hub.x) {
                    return -WG_VPNMAP.nodeWidth / 2;
                }
                return WG_VPNMAP.nodeWidth;
            });
    },
    deviceOnDblClick: function (d) {
        d3.select(this)
            .classed("fixed", function () { d.fixed = false; });
    },
    OnDragStart: function (d) {
        if (d.type === 'hub') {
            d3.select(this).classed("fixed", function () { d.fixed = true; });
        }
    },
    update: function (nodes, links, legend) {
        // Set x and y so we drop in rather than explode chaotically at init
        WG_VPNMAP.nodes = nodes;

        var device_idx = 1;
        nodes[0].x = WG_VPNMAP.w / 2 - 100;
        nodes[0].y = WG_VPNMAP.h / 2;
        for (device_idx = 1; device_idx < nodes.length; device_idx++) {
            nodes[device_idx].x = device_idx * WG_VPNMAP.w / nodes.length * 2;
            nodes[device_idx].y = 0;
            if (device_idx > nodes.length / 2) {
                nodes[device_idx].y = WG_VPNMAP.h / 2 + 1;
            }
        }
        var charge = 420;
        if (nodes.length > WG_VPNMAP.nodeThresholds[0]) {
            WG_VPNMAP.hubnodeHeight = 13;
            WG_VPNMAP.nodeWidth = 11;
            WG_VPNMAP.nodeHeight = 11;
            WG_VPNMAP.linkStrokeWidth = '0.5px';
            charge = 120;
        }

        WG_VPNMAP.bRunning = true;

        WG_VPNMAP.force.stop();
        // Restart the force layout.
        WG_VPNMAP.force
            .charge(-charge)
            .nodes(nodes)
            .links(links)
            .start();

        // Update the links...
        WG_VPNMAP.linkPath = WG_VPNMAP.vis.selectAll("path.link")
            .data(links, function (d) { return d.name; })
            .attr("fill", WG_VPNMAP.clrLinkState)
            .attr("stroke-width", WG_VPNMAP.linkStrokeWidth)
            .attr("stroke", WG_VPNMAP.clrLinkState)
            .style("stroke-dasharray", WG_VPNMAP.strokeDashLinkState);
        WG_VPNMAP.linkPath.enter().insert("svg:path", ".node")
            .attr("class", "link")
            .attr("fill", WG_VPNMAP.clrLinkState)
            .attr("stroke-width", WG_VPNMAP.linkStrokeWidth)
            .attr("stroke", WG_VPNMAP.clrLinkState)
            .style("fill", "none") // css fill should be none, fill attr specified above
            .style("stroke-dasharray", WG_VPNMAP.strokeDashLinkState)
            .attr("d", WG_VPNMAP.drawLinkPath);

        // Exit any old links.
        WG_VPNMAP.linkPath.exit().remove();

        // Update the nodes...
        WG_VPNMAP.nodePath = WG_VPNMAP.vis.selectAll("g.node")
            .data(nodes)
            .attr("class", WG_VPNMAP.classNode)
            .style("color", "Black");

        WG_VPNMAP.nodePath.select(".noderect")
            .style("stroke", WG_VPNMAP.clrNodeState)
            .style("fill", WG_VPNMAP.clrNodeStateFill);

        WG_VPNMAP.nodePath.select('text.nodetext')
            .text(WG_VPNMAP.text);

        WG_VPNMAP.nodePath.transition()
            .attr("r", function (d) { return 4.5; });

        var drag = WG_VPNMAP.force.drag()
            // sticky
            .on("dragstart", WG_VPNMAP.OnDragStart);
        var graph = WG_VPNMAP.nodePath.enter().append("svg:g")
            .style("font-size", "9px")
            .attr("class", WG_VPNMAP.classNode)
            .on("mousedown", WG_VPNMAP.deviceOnMouseDown)
            .on("mouseover", WG_VPNMAP.deviceOnMouseOver)
            .on("mouseup", WG_VPNMAP.deviceOnMouseOut)
            .on("mouseout", WG_VPNMAP.deviceOnMouseOut)
            .call(drag);

        // Enter any new nodes.
        var nodetext_class = "nodetext";
        if (WG_VPNMAP.nodes.length > WG_VPNMAP.nodeThresholds[0]) {
            nodetext_class += " hide";
        }
        graph.append("svg:text")
            .style("stroke-width", "0px")
            .attr("class", nodetext_class)
            .attr("dy", 5)
            .text(WG_VPNMAP.text);

        graph.append(function (d) {
            var elementname = "rect";
            if (d.type === 'hub') {
                elementname = "circle";
            }
            return document.createElementNS(d3.ns.prefix.svg, elementname);
        })
            .attr("class", "noderect")
            .attr("cx", "0px")
            .attr("cy", "0px")
            .attr("x", -2)
            .attr("y", -2)
            .attr("r", function (d) { return WG_VPNMAP.hubnodeHeight; })
            .attr("width", WG_VPNMAP.nodeWidth)
            .attr("height", WG_VPNMAP.nodeHeight)
            .attr("text-anchor", "middle")
            .on("dblclick", WG_VPNMAP.deviceOnDblClick)
            .on("click", WG_VPNMAP.deviceOnMouseClick)
            .style("cursor", "pointer")
            .style("stroke", WG_VPNMAP.clrNodeState)
            .style("fill", WG_VPNMAP.clrNodeStateFill);

        // Exit any old nodes.
        WG_VPNMAP.nodePath.exit().remove();

        if (legend) {
            WG_VPNMAP.legendData = legend;
        }
        WG_VPNMAP.drawLegend(WG_VPNMAP.legendData);
    },
    getLinkDistance: function (d) {
        var length = Math.min(WG_VPNMAP.w, WG_VPNMAP.h);
        if (length > 500) {
            return 4 * (length / 10);
        }
        if (d.target.active_tunnel_num === 0) {
            return 3 * (length / 10);
        }
        return 2.5 * (length / 10);

    },
    drawLinkPath: function (d) {
        var dx = d.target.x - d.source.x,
            dy = d.target.y - d.source.y,
            dr = Math.sqrt(dx * dx + dy * dy);
        var arc_threshold = 92;

        var linkpath = "M" + d.source.x + "," + d.source.y + "A" + dr + "," + dr +
            " 0 0,1 " + d.target.x + "," + d.target.y;

        if (d.target.x - d.source.x < arc_threshold && d.target.x - d.source.x > -arc_threshold) {
            linkpath = "M" + d.source.x + "," + d.source.y +
                "L" + (d.source.x + dx / 2) + "," + d.target.y +
                "L" + d.target.x + "," + d.target.y;
        } else if ((d.target.x > d.source.x && d.target.y > d.source.y)
                || (d.target.x < d.source.x && d.target.y < d.source.y)) {
            // Flip it
            linkpath = "M" + d.target.x + "," + d.target.y + "A" + dr + "," + dr +
                " 0 0,1 " + d.source.x + "," + d.source.y;
        }

        return linkpath;
    },
    text: function (d) {
        return d.name_disp;
    },

    // Color leaf nodes orange, and packages white or blue.
    strokeNode: function (d) {
        switch (d.type) {
        case 'spoke':
            return WG_VPNMAP.clrWgrdRed;
        }
        return 'none';
    },
    strokeLink: function (d) {
        return WG_VPNMAP.fillLink(d);
    },
    calcState: function (data) {
        /* 3 - Green, 2 - Hollow Green, 1 - Grey, 0 - Red */
        if (!data) {
            return 0;
        }
        if (data.type === 'hub') {
            return 3;
        }
        if (data.total_tunnel_num === 0) {
            return 1;
        }
        if (data.total_tunnel_num === data.active_tunnel_num) {
            return 3;
        }
        if (data.total_tunnel_num > 0 && data.active_tunnel_num === 0) {
            return 0;
        }
        if (data.total_tunnel_num > 0 && data.active_tunnel_num > 0) {
            return 2;
        }
        return 1;
    },
    strokeDashLinkState: function (d) {
        var target_state = WG_VPNMAP.calcState(d.target);
        switch (target_state) {
        case 3:
            return "1, 0";
        default:
            return "5, 1";
        }
    },
    clrLinkState: function (d) {
        var target_state = WG_VPNMAP.calcState(d.target);
        switch (target_state) {
        case 3:
        case 2:
            return WG_VPNMAP.clrWgrdGrn;
        case 1:
            return WG_VPNMAP.clrWgrdGry;
        case 0:
            return WG_VPNMAP.clrWgrdRed;
        }
    },
    clrNodeStateFill: function (d) {
        var state = WG_VPNMAP.calcState(d);
        switch (state) {
        case 3:
            return WG_VPNMAP.clrWgrdGrn;
        case 2:
            return 'White';
        case 1:
            return WG_VPNMAP.clrWgrdGry;
        case 0:
            return WG_VPNMAP.clrWgrdRed;
        }
    },
    clrNodeState: function (d) {
        var state = WG_VPNMAP.calcState(d);
        switch (state) {
        case 3:
        case 2:
            return WG_VPNMAP.clrWgrdGrn;
        case 1:
            return WG_VPNMAP.clrWgrdGry;
        case 0:
            return WG_VPNMAP.clrWgrdRed;
        }
    },
    classNode: function (d) {
        if (d.type === 'hub') {
            return "node node" + "_HUB";
        }
        return "node node" + d.spoke_id;
    },
    deviceOnMouseDown: function (d) {
        WG_VPNMAP.isdrag = true;
    },
    deviceOnMouseOver: function (d) {
        if (WG_VPNMAP.nodes.length > WG_VPNMAP.nodeThresholds[0]) {
            $(".nodetext").hide();
            $(".node" + d.spoke_id + " .nodetext").show();
            $(".node_HUB .nodetext").show();
        }
    },
    deviceOnMouseOut: function (d) {
        WG_VPNMAP.isdrag = false;
        $(".node.node" + d.id).attr("font-size", "");
        $(".node").show();
        $("#popup").hide();
    },
    deviceOnMouseClick: function (d) {
        if (d3.event.defaultPrevented) { return; } // ignore drag
        WG_VPNMAP.doNodePopover(d);
        var dx = 350;
        var dy = 145;
        if (d.type === 'spoke') {
            dy = 175;
        }
        return WG_VPNMAP.doPositionNodePopover("#chart", d, dx, dy);
    },
    doNodePopover: function (d) {
        $("#cxn_popup").show();

        $("#cxn_popup_title").html(escapeHtml(d.name_disp));

        var resources = '<table>';
        if (d.type === 'hub') {
            resources += S_VPN_HUB_DEVICE;
        } else {
            if (d.total_tunnel_num === 0 && d.active_tunnel_num === 0) {
                resources += '<tr><td>' + S_VPNMAP_NODATA + '</td><td></td></tr>';
            } else {
                resources += '<tr><td width="125">' + S_VPNMAP_TOTAL_TUNNELS + '</td><td>' + d.total_tunnel_num + '</td></tr>';
                resources += '<tr><td>' + S_VPNMAP_ACTIVE_TUNNELS + '</td><td>' + d.active_tunnel_num + '</td></tr>';
                resources += '<tr><td>' + S_VPNMAP_TOTAL_SENT + '</td><td>' + $.formatBytes(d.total_sent_bytes) + '</td></tr>';
                resources += '<tr><td>' + S_VPNMAP_TOTAL_RECEIVED + '</td><td>' + $.formatBytes(d.total_received_bytes) + '</td></tr>';
            }
        }
        resources += '</table>';
        resources += '<span id="cxn_popup_spinner" class="loading"><img width="14" height="14" src="/images/loader.gif" /></span>';

        WG_VPNMAP.popover_spoke_id = null;
        if (d.spoke_id && d.type === 'spoke') {
            WG_VPNMAP.popover_spoke_id = d.spoke_id;
            resources += '<div style="padding-top:7px;"><a id="vpnmap_edit_spoke" href="#">' + S_VPNMAP_EDIT_SPOKE + '</a></div>';
        }
        if (d.device_id) {
            resources += '<div style="padding-top:7px;">' + S_VPNMAP_OPEN_WEBUI + ' <a class="xtmwebui_link" href="/control/xtmwebui?sn=' + d.device_id + '&target_page=' + WG_VPNMAP.webui_link_path + '" target="xtmwebui_' + d.device_id + '">' + S_VPNMAP_OPEN_WEBUI_VPNSTATISTICS + '</a></div>';
        }
        resources += '</div>';
        $("#cxn_popup_resources").html(resources);
        $("#cxn_popup_spinner").hide();
    },
    doPositionNodePopover: function (parent_id, d, dx, dy) {
        var x = WG_VPNMAP.mousePos[0],
            y = WG_VPNMAP.mousePos[1];

        var width = $(window).width();
        var height = $(window).height();
        var offset_margin = 10;
        if (x + dx > width) {
            x -= dx - offset_margin;
        }
        if (x < 0) {
            x = 0;
        }
        if (y + dy > height) {
            y -= dy - offset_margin;
        }
        $("#cxn_popup").offset({ top: y, left: x });
        $("#cxn_popup").width(dx);
        $("#cxn_popup").height(dy);

        var title_height = $("#cxn_popup" + " .popover-title").outerHeight();
        var resources_height = dy - title_height - 20;
        $("#cxn_popup" + " .popover-content").height(resources_height);
    },
    drawLastUpdate: function (vpn_health_time) {
        WG_VPNMAP.vis.selectAll(".lastupdate").remove();

        WG_VPNMAP.vis.append("g")
            .attr("class", "lastupdate")
            .append("text")
            .attr("x", 0)
            .attr("y", WG_VPNMAP.h - 25)
            .attr("dy", ".35em")
            .style("font-family", "Open Sans")
            .style("font-size", "0.8em")
            .style("fill", "#666666")
            .style("text-anchor", "left")
            .text(vpn_health_time);
    },
    drawLegend: function (data) {
        WG_VPNMAP.vis.selectAll(".legend").remove();
        WG_VPNMAP.vis.selectAll(".titlelegend").remove();

        WG_VPNMAP.drawLastUpdate(data.vpn_health_time);
        WG_VPNMAP.vis.append("g")
            .attr("class", "titlelegend")
            .append("text")
            .attr("x", 0)
            .attr("y", 20)
            .attr("dy", ".35em")
            .style("font-family", "Raleway")
            .style("font-size", "21px")
            .style("line-height", "32px")
            .style("text-rendering", "optimizelegibility")
            .style("fill", "#666666")
            .style("text-anchor", "left")
            .text(S_VPN_HUB_AND_SPOKE);

        var margin_right = 5;
        var legend = WG_VPNMAP.vis.append("g")
            .attr("class", "legend");
        legend
            .append("text")
                .attr("x", WG_VPNMAP.w - margin_right)
                .attr("y", 20)
                .attr("dy", ".35em")
                .style("font-size", "14px")
                .style("fill", "#666666")
                .style("font-weight", "bold")
                .style("text-anchor", "end")
                .text(data.title);

        var idx = 0;
        for (idx = 0; idx < data.list.length; idx++) {
            legend.append("text")
                .attr("x", WG_VPNMAP.w - margin_right)
                .attr("y", 40 + idx * 15)
                .attr("dy", ".35em")
                .style("font-size", "12px")
                .style("fill", "#666666")
                .style("text-anchor", "end")
                .text(data.list[idx]);
        }
        if (manage_vpn_perm) {
            legend.append("svg:a")
                .attr("xlink:href", "#")
                .on("click", function () {
                    d3.event.stopPropagation();
                })
                .append("svg:text")
                    .attr("x", WG_VPNMAP.w - margin_right)
                    .attr("y", 60 + idx * 15)
                    .on("click", data.button_callback)
                    .attr("dy", ".35em")
                    .attr("text-anchor", "end")
                    .style("border-bottom", "1px dotted")
                    .style("fill", "#2bbed8")
                    .text(data.button_text);
        }
    },
    doResize: function () {
        WG_VPNMAP.w = $("#chart").width();
        WG_VPNMAP.h = 350;
        if (WG_VPNMAP.w > 1024) {
            WG_VPNMAP.h = 450;
        }

        WG_VPNMAP.vis
            .attr("width", WG_VPNMAP.w)
            .attr("height", WG_VPNMAP.h);

        WG_VPNMAP.force
            .size([WG_VPNMAP.w, WG_VPNMAP.h])
            .start();
        WG_VPNMAP.drawLegend(WG_VPNMAP.legendData);
    }
};
$(document).ready(WG_VPNMAP.init);
