/*global R_DATE_NAVBAR, S_MOBILE_DETAIL, checkLoginPageRedirect, resizegrid, showChart, showChartLoading, showChartEmpty, plotChart, report_plots, escape, alert, S_EXPORTING_FILE, S_PROCESSING, anonymization_enabled*/
var D_MOBILE_DEVICE = {
    period: '1d',
    urlSn : '',
    htmlDate: '',
    htmlSn: '',
    urlTz: '',
    report_plots: [],
    repType: 'mobile_summary',
    seriesEarliestRecord : '',
    seriesLatestRecord : '',
    detailRepName: 'mobile_detail',
    detailRepPath: '/report/detail?sn=',

    init: function () {
        D_MOBILE_DEVICE.htmlDate = $("#date").val();
        D_MOBILE_DEVICE.urlSn = $.getUrlVar('sn');
        D_MOBILE_DEVICE.htmlSn = $("#sn").val();
        D_MOBILE_DEVICE.urlTz = $.getUrlVar('tz');
        D_MOBILE_DEVICE.initEvents();
    },

    initEvents: function () {
        $('#md_sum_pdf').click(function () {
            WGRD.progressModal(S_EXPORTING_FILE, S_PROCESSING);

            $.ajax({
                url: "/report/saveAsPdf?serial=" + D_MOBILE_DEVICE.htmlSn + "&client_tz=" + WGRD.client_tz + "&report_type=" + D_MOBILE_DEVICE.repType +
                     "&start_time=" + D_MOBILE_DEVICE.seriesEarliestRecord + "&end_time=" + D_MOBILE_DEVICE.seriesLatestRecord,
                type: 'POST',
                contentType: 'application/json',
                success: function (data) {
                    if (!data.status) {
                        if (data.message) {
                            alert(data.message);
                        }
                        return true;
                    }
                    var file_args = '&tmp_file_name=' + data.tmp_file_name + '&file_name=' + data.file_name;
                    window.location = "/report/get_pdf_file?serial=" + D_MOBILE_DEVICE.htmlSn + file_args;
                    return false;
                },
                complete: function (filename) {
                    WGRD.progressModalClose();
                }
            });
        });

        $("#custom_datepicker_trigger").bind('click', function () {
            // Listen for a click on this div, it means the date changed 
            // and a refresh is needed
            D_MOBILE_DEVICE.getData();
        });

        $(window).bind('resizeEnd', function () {
            D_MOBILE_DEVICE.doResize();
        });

        $(document).on('click', '.mobiledialog', S_MOBILE_DETAIL.showDetailsDialog);
    },

    doResize : function () {
        var grid = "#grid_area";
        var parent = "#grid_data";
        var grid_width = resizegrid();
        $("#webui_content").width(grid_width);
        $(grid).setGridWidth(100, true);
        $(grid).setGridWidth($(parent).width(), true);

        var resizePlots = D_MOBILE_DEVICE.report_plots;
        var plot, id, chart_area_width;
        for (plot in resizePlots) {
            if (resizePlots.hasOwnProperty(plot)) {
                id = plot.slice(0, plot.search('_chart_graph'));
                chart_area_width = $('#' + id + '_chart_area').width();
                if (resizePlots[plot]) {
                    $('#' + plot).width(chart_area_width * 0.95);
                    resizePlots[plot].replot();
                }
            }
        }
    },

    clonePlots: function (obj) {
        var target = {};
        var i;
        for (i in obj) {
            if (obj.hasOwnProperty(i)) {
                target[i] = obj[i];
            }
        }
        return target;
    },

    plotPieCharts : function (series) {
        D_MOBILE_DEVICE.report_plots = [];
        if (series.length !== 0) {
            var i;
            var chart;
            for (i = 0; i < series.length; i++) {
                chart = series[i].div + '_chart';
                showChart(chart);
                plotChart(series[i], chart, true);
                if (series[i].div === 'type') {
                    $("#type_chart_stats").text(series[i].chart_description.desc);
                }
            }
            // save report plots to resize
            D_MOBILE_DEVICE.report_plots = D_MOBILE_DEVICE.clonePlots(report_plots);
        } else {
            D_MOBILE_DEVICE.showEmptyPieCharts();
        }
    },

    retrieveData: function (series) {
        if (series.earliest_record !== '') {
            D_MOBILE_DEVICE.seriesEarliestRecord = series.earliest_record;
        }
        if (series.latest_record !== '') {
            D_MOBILE_DEVICE.seriesLatestRecord = series.latest_record;
        }

        // Unload the grid and then recreate it and populate the rows
        jQuery("#grid_area").GridUnload("#grid_area");

        // When series contains no data, series.grid_sord is undefined,
        // which causes createGrid() to raise an error.
        // Can't let this function return at the beginning when series has no data,
        // because it would make the empty report shown not like usual
        if (series.grid_sort) {
            D_MOBILE_DEVICE.createGrid(series.col_names, series.col_model, series.grid_sort);
        }

        var i = 0;
        for (i = 0; i <= series.grid_data.length; i++) {
            $("#grid_area").jqGrid('addRowData', i + 1, series.grid_data[i]);
        }
        $("#grid_area").setGridParam({rowNum: i});

        $("#grid_area").jqGrid('footerData', 'set', series.footer, false);
    },

    // Report DataGrid
    createGrid : function (colNames, colModel, gridSort) {
        $("#grid_area").jqGrid({
            datatype: "local",
            colNames: colNames,
            colModel: colModel,
            sortname: gridSort.sortname,
            sortorder: gridSort.sortorder,
            autoencode: true,
            height: 'auto',
            autowidth: true,
            shrinkToFit: true,
            footerrow: true
        });
        if (anonymization_enabled !== 1) {
            $("#grid_area").setColProp('hostname', { formatter: D_MOBILE_DEVICE.mobileLinkFormatter });
            $("#grid_area").setColProp('user', { formatter: D_MOBILE_DEVICE.mobileLinkFormatter });
        }
        $("#grid_area").setColProp('check', { formatter: D_MOBILE_DEVICE.mobileLinkFormatter });
    },

    mobileLinkFormatter: function (elem, cellval, opts) {
        var uri = "/report/detail?sn=" + D_MOBILE_DEVICE.urlSn + "&reptype=mobile_detail&search=";
        var name = cellval.colModel.name;
        if (name === 'hostname') {
            uri = uri + encodeURIComponent('hostname=' + elem);
        } else if (name === 'user') {
            uri = uri + encodeURIComponent('user=' + elem);
        } else if (name === 'check') {
            if (opts.checkval === 2) {
                // If compliance_status is 2, which means Unknown, no need to add a link to it.
                return elem;
            }
            // checkinfo is '<update_time>:<compliance_status>:<compliance_setting>:<device_type>'.
            var checkinfo = encodeURIComponent(opts.last + ';' + opts.checkval + ';' + opts.setting + ';' + opts.dev_type);
            return "<a href='' data-checkinfo='" + checkinfo + "' class='mobiledialog' >" + elem + "</a>";
        }
        return '<a href="' + uri + '">' + elem + '</a>';
    },

    showHideDetailsLink: function (b) {
        $('#view_details_link').hide();
        if (b && anonymization_enabled !== 1) {
            $('#view_details_link').show();
            var detail_href = D_MOBILE_DEVICE.detailRepPath + D_MOBILE_DEVICE.htmlSn + '&reptype=' + D_MOBILE_DEVICE.detailRepName;
            $('#view_details_link').attr('href', detail_href);
        }
    },

    showHideLinkIcon: function (b) {
        $("#md_sum_pdf").hide();
        if (b) {
            $("#md_sum_pdf").show();
        }
    },

    showEmptyPieCharts: function () {
        showChartEmpty('check_chart');
        showChartEmpty('type_chart');
        showChartEmpty('vpn_chart');
    },

    showPieChartsLoading: function () {
        showChartLoading('check_chart');
        showChartLoading('type_chart');
        showChartLoading('vpn_chart');
    },

    toggleSpinner: function (b) {
        D_MOBILE_DEVICE.showHideDetailsLink(b);
        D_MOBILE_DEVICE.showHideLinkIcon(b);
        if (!b) {
            D_MOBILE_DEVICE.showEmptyPieCharts();
            $("#type_chart_stats").text('');
        }
    },

    onDataReceived: function (data) {
        //{'count':, 'charts_data':, 'grid_data':}
        if (data.count > 0) {
            D_MOBILE_DEVICE.plotPieCharts(data.charts_data);
            D_MOBILE_DEVICE.retrieveData(data.grid_data);
            D_MOBILE_DEVICE.toggleSpinner(true);
        }
    },

    getData: function () {
        var dt = R_DATE_NAVBAR.getStartEndSeconds();
        var start_dt = dt[0];
        var end_dt = dt[1];
        var url = 'get_md_data?sn=' + D_MOBILE_DEVICE.urlSn + '&start_time=' + start_dt + '&end_time=' + end_dt;

        D_MOBILE_DEVICE.showPieChartsLoading();
        $.ajax({
            url: url,
            method: 'GET',
            dataType: 'json',
            error: function (xhr, status, error) {
                checkLoginPageRedirect(xhr, status, error);
            },
            success: function (data) {
                if (!data.count || data.count === 0) {
                    D_MOBILE_DEVICE.retrieveData(data);
                    D_MOBILE_DEVICE.toggleSpinner(false);
                    return;
                }
                D_MOBILE_DEVICE.onDataReceived(data);
            },
            complete: function () {
                D_MOBILE_DEVICE.doResize();
            }
        });
    }
};
$(document).ready(D_MOBILE_DEVICE.init);