/*global showChart, plotChart, getStartEndSeconds, showChartLoading, report_plots, S_EXPORTING_FILE, S_PROCESSING, R_DATE_NAVBAR, checkLoginPageRedirect, D_SS_UNIT_TRILLION, D_SS_UNIT_BILLION, D_SS_UNIT_MILLION, D_SS_UNIT_THOUSAND*/

var D_SUBSCRIPTION = {
    ssData : '',
    urlSn : '',
    htmlDate: '',
    htmlSn: '',
    urlTz: '',
    report_plots: [],
    wb: false,
    app_cntrl: false,
    gav: false,
    ips: false,
    apt: false,
    botnet: false,
    red: false,
    dlp: false,
    spam: false,
    progress_index: 0,
    tid: null,
    progressTimeout: 1000,

    init: function () {
        D_SUBSCRIPTION.urlID = $.getUrlVar('id');
        D_SUBSCRIPTION.htmlDate = $("#date").val();
        D_SUBSCRIPTION.urlSn = $.getUrlVar('sn');
        D_SUBSCRIPTION.htmlSn = $("#sn").val();
        D_SUBSCRIPTION.urlTz = $.getUrlVar('tz');
        D_SUBSCRIPTION.initEvents();
    },

    initEvents: function () {
        /* Respond to resizeEnd event */
        $(window).bind('resizeEnd', function () {
            D_SUBSCRIPTION.doResize();
        });

        $("#custom_datepicker_trigger").bind('click', function () {
            // Listen for a click on this div, it means the date changed 
            // and a refresh is needed
            D_SUBSCRIPTION.getData();
        });

        //Point titles to activity charts
        $('#wb_dashboard').find('.pointer').click(function () {
            window.location = '/report/webblocker?sn=' + D_SUBSCRIPTION.htmlSn + '&reptype=wb_activity';
            return;
        });

        $('#app_cntrl_dashboard').find('.pointer').click(function () {
          //TODO
            return;
        });

        $('#gav_dashboard').find('.pointer').click(function () {
            window.location = '/report/gav?sn=' + D_SUBSCRIPTION.htmlSn + '&reptype=gav_activity';
        });

        $('#ips_dashboard').find('.pointer').click(function () {
            window.location = '/report/ips?sn=' + D_SUBSCRIPTION.htmlSn + '&reptype=ips_activity';
        });

        $('#apt_dashboard').find('.pointer').click(function () {
            window.location = '/report/apt?sn=' + D_SUBSCRIPTION.htmlSn + '&reptype=apt_activity';
        });

        $('#botnet_dashboard').find('.pointer').click(function () {
            window.location = '/report/botnet?sn=' + D_SUBSCRIPTION.htmlSn + '&reptype=botnet_activity';
        });

        $('#red_dashboard').find('.pointer').click(function () {
            window.location = '/report/red?sn=' + D_SUBSCRIPTION.htmlSn + '&reptype=red_activity';
        });

        $('#dlp_dashboard').find('.pointer').click(function () {
            window.location = '/report/dlp?sn=' + D_SUBSCRIPTION.htmlSn + '&reptype=dlp_activity';
        });

        $('#spam_dashboard').find('.pointer').click(function () {
            document.location.href = '/report/spamblocker?sn=' + D_SUBSCRIPTION.htmlSn + '&reptype=spam_activity';
        });

        //Save as PDF
        $('#ss_sum_pdf').find('img').click(function (eo) {
            eo.preventDefault();
            var pdf_state = $(this).css('cursor');
            if (pdf_state === 'default') {
                return;
            }
            var startEnd = R_DATE_NAVBAR.getStartEndIsoStr();
            var startTime = startEnd[0];
            var endTime = startEnd[1];

            startTime = R_DATE_NAVBAR.convertDateStr2GMT(startTime + ':00');
            endTime = R_DATE_NAVBAR.convertDateStr2GMT(endTime + ':00');

            var repType = 'ss_activity';

            WGRD.progressModal(S_EXPORTING_FILE, S_PROCESSING);

            $.ajax({
                url: "/report/saveAsPdf?serial=" + D_SUBSCRIPTION.urlSn + "&client_tz=" + WGRD.client_tz + "&start_time=" + startTime + "&end_time=" + endTime + "&report_type=" + repType,
                type: 'POST',
                contentType: 'application/json',
                success: function (data) {
                    if (!data.status) {
                        if (data.message) {
                            WGRD.okMessageModal(data.message, '');
                        }
                        return true;
                    }
                    var file_args = '&tmp_file_name=' + data.tmp_file_name + '&file_name=' + data.file_name;
                    window.location = "/report/get_pdf_file?serial=" + D_SUBSCRIPTION.urlSn + file_args;
                    return false;
                },
                complete: function (filename) {
                    WGRD.progressModalClose();
                }
            });
        });
    },

    getData : function () {
        clearTimeout(D_SUBSCRIPTION.tid);
        var dt = R_DATE_NAVBAR.getStartEndSeconds();
        var start_dt = dt[0];
        var end_dt = dt[1];
        var url = 'get_ss_data?sn=' + D_SUBSCRIPTION.urlSn + '&start_time=' + start_dt + '&end_time=' + end_dt;
        D_SUBSCRIPTION.resetProgressBar();

        $.ajax({
            url: url,
            method: 'GET',
            dataType: 'json',
            error: function (xhr, status, error) {
                checkLoginPageRedirect(xhr, status, error);
            },
            success: function (data) {
                if (!data.ss_data) {
                    WGRD.showUIElements(false, ['#ss_dashboard']);
                    return;
                }
                WGRD.showUIElements(true, ['#ss_dashboard']);
                D_SUBSCRIPTION.ssData = data.ss_data;
                D_SUBSCRIPTION.loadSecurityServices();
            },
            complete: function () {
                D_SUBSCRIPTION.doResize();
                D_SUBSCRIPTION.tid = setTimeout(function () {
                    D_SUBSCRIPTION.toggleProgressBar(false);
                }, D_SUBSCRIPTION.progressTimeout);
            }
        });
    },

    loadSecurityServices: function () {
        var counter_stats, uri;
        var progress_level = 0;
        var ss_data = D_SUBSCRIPTION.ssData;

        D_SUBSCRIPTION.getProgressUnits(ss_data);

        //Blocked Websites 
        if (D_SUBSCRIPTION.wb) {
            D_SUBSCRIPTION.showSSChart('wb', ss_data.wb.data);
            //Set Counter data
            if (ss_data.wb.data.counter_stats) {
                counter_stats = ss_data.wb.data.counter_stats;
                $('#wb_total_scan').text(D_SUBSCRIPTION.getDisplayNumberFormat(Number(counter_stats.total_requests)));
                $('#wb_count1').text(D_SUBSCRIPTION.getDisplayNumberFormat(Number(counter_stats.total_denied)));
            }
            // Set the Summary report link
            uri = '/report/webblocker?sn=' + D_SUBSCRIPTION.urlSn + '&reptype=wb_activity';
            $('#wb_view_summary').attr('href', uri);

            D_SUBSCRIPTION.showProgress(++progress_level);
        }

        //Blocked Applications 
        if (D_SUBSCRIPTION.app_cntrl) {
            D_SUBSCRIPTION.showSSChart('app_cntrl', ss_data.app_cntrl.data);
            if (ss_data.app_cntrl.data.counter_stats) {
                counter_stats = ss_data.app_cntrl.data.counter_stats;
                //TODO Set Counter data
                //$('#app_cntrl_total_scan').text(counter_stats.total_applications);
                //$('#app_cntrl_count1').text(counter_stats.total_denied_applications);
            }
            //TODO Set the Summary report link

            D_SUBSCRIPTION.showProgress(++progress_level);
        }

        //GAV
        if (D_SUBSCRIPTION.gav) {
            D_SUBSCRIPTION.showSSChart('gav', ss_data.gav.data);
            if (ss_data.gav.data.counter_stats) {
                counter_stats = ss_data.gav.data.counter_stats;
                $('#gav_total_scan').text(D_SUBSCRIPTION.getDisplayNumberFormat(Number(counter_stats.total_scanned)));
                $('#gav_count1').text(D_SUBSCRIPTION.getDisplayNumberFormat(Number(counter_stats.total_drop)));
            }
            //Set the Summary report link
            uri = '/report/gav?sn=' + D_SUBSCRIPTION.urlSn + '&reptype=gav_activity';
            $('#gav_view_summary').attr('href', uri);

            D_SUBSCRIPTION.showProgress(++progress_level);
        }

        //IPS
        if (D_SUBSCRIPTION.ips) {
            D_SUBSCRIPTION.showSSChart('ips', ss_data.ips.data);
            if (ss_data.ips.data.counter_stats) {
                counter_stats = ss_data.ips.data.counter_stats;
                $('#ips_total_scan').text(D_SUBSCRIPTION.getDisplayNumberFormat(Number(counter_stats.total_scanned)));
                $('#ips_count1').text(D_SUBSCRIPTION.getDisplayNumberFormat(Number(counter_stats.total_detected)));
                $('#ips_count2').text(D_SUBSCRIPTION.getDisplayNumberFormat(Number(counter_stats.total_prevented)));
            }
            //Set the Summary report link
            uri = '/report/ips?sn=' + D_SUBSCRIPTION.urlSn + '&reptype=ips_activity';
            $('#ips_view_summary').attr('href', uri);

            D_SUBSCRIPTION.showProgress(++progress_level);
        }

        //APT
        if (D_SUBSCRIPTION.apt) {
            D_SUBSCRIPTION.showSSChart('apt', ss_data.apt.data);
            if (ss_data.apt.data.counter_stats) {
                counter_stats = ss_data.apt.data.counter_stats;
                $('#apt_total_scan').text(D_SUBSCRIPTION.getDisplayNumberFormat(Number(counter_stats.total_scanned)));
                $('#apt_count1').text(D_SUBSCRIPTION.getDisplayNumberFormat(Number(counter_stats.total_prevented)));
                $('#apt_count2').text(D_SUBSCRIPTION.getDisplayNumberFormat(Number(counter_stats.total_zeroday_detected)));
            }
            //Set the Summary report link
            uri = '/report/apt?sn=' + D_SUBSCRIPTION.urlSn + '&reptype=apt_activity';
            $('#apt_view_summary').attr('href', uri);

            D_SUBSCRIPTION.showProgress(++progress_level);
        }

        //Botnet
        if (D_SUBSCRIPTION.botnet) {
            D_SUBSCRIPTION.showSSChart('botnet', ss_data.botnet.data);
            if (ss_data.botnet.data.counter_stats) {
                counter_stats = ss_data.botnet.data.counter_stats;
                $('#botnet_total_scan').text(D_SUBSCRIPTION.getDisplayNumberFormat(Number(counter_stats.total_src_tested) +
                        Number(counter_stats.total_dst_tested)));
                $('#botnet_count1').text(D_SUBSCRIPTION.getDisplayNumberFormat(Number(counter_stats.total_src_dropped) +
                        Number(counter_stats.total_dst_dropped)));
            }
            //Set the Summary report link
            uri = '/report/botnet?sn=' + D_SUBSCRIPTION.urlSn + '&reptype=botnet_activity';
            $('#botnet_view_summary').attr('href', uri);

            D_SUBSCRIPTION.showProgress(++progress_level);
        }

        //RED
        if (D_SUBSCRIPTION.red) {
            D_SUBSCRIPTION.showSSChart('red', ss_data.red.data);
            if (ss_data.red.data.counter_stats) {
                counter_stats = ss_data.red.data.counter_stats;
                $('#red_total_scan').text(D_SUBSCRIPTION.getDisplayNumberFormat(Number(counter_stats.total_bad) +
                        Number(counter_stats.total_good) + Number(counter_stats.total_inconclusive)));
                $('#red_count1').text(D_SUBSCRIPTION.getDisplayNumberFormat(Number(counter_stats.total_bad)));
            }
            //Set the Summary report link
            uri = '/report/red?sn=' + D_SUBSCRIPTION.urlSn + '&reptype=red_activity';
            $('#red_view_summary').attr('href', uri);

            D_SUBSCRIPTION.showProgress(++progress_level);
        }

        //DLP
        if (D_SUBSCRIPTION.dlp) {
            D_SUBSCRIPTION.showSSChart('dlp', ss_data.dlp.data);
            if (ss_data.dlp.data.counter_stats) {
                counter_stats = ss_data.dlp.data.counter_stats;
                $('#dlp_total_scan').text(D_SUBSCRIPTION.getDisplayNumberFormat(Number(counter_stats.total_scanned)));
                $('#dlp_count1').text(D_SUBSCRIPTION.getDisplayNumberFormat(Number(counter_stats.total_drop)));
            }
            //Set the Summary report link
            uri = '/report/dlp?sn=' + D_SUBSCRIPTION.urlSn + '&reptype=dlp_activity';
            $('#dlp_view_summary').attr('href', uri);

            D_SUBSCRIPTION.showProgress(++progress_level);
        }

        //spam
        if (D_SUBSCRIPTION.spam) {
            D_SUBSCRIPTION.showSSChart('spam', ss_data.spam.data);
            if (ss_data.spam.data.counter_stats) {
                counter_stats = ss_data.spam.data.counter_stats;
                $('#spam_total_scan').text(D_SUBSCRIPTION.getDisplayNumberFormat(Number(counter_stats.total_scanned)));
                $('#spam_count1').text(D_SUBSCRIPTION.getDisplayNumberFormat(Number(counter_stats.total_drop)));
            }
            //Set the Summary report link
            uri = '/report/spamblocker?sn=' + D_SUBSCRIPTION.urlSn + '&reptype=spam_activity';
            $('#spam_view_summary').attr('href', uri);

            D_SUBSCRIPTION.showProgress(++progress_level);
        }

        D_SUBSCRIPTION.report_plots = D_SUBSCRIPTION.clonePlots(report_plots);
    },

    clonePlots: function (obj) {
        var target = {};
        var i;
        for (i in obj) {
            if (obj.hasOwnProperty(i)) {
                target[i] = obj[i];
            }
        }
        return target;
    },

    getProgressUnits: function (ss_data) {
        D_SUBSCRIPTION.progress_index = 0;
        //Blocked Websites 
        if (ss_data.wb && ss_data.wb.data.count > 0) {
            D_SUBSCRIPTION.wb = true;
            D_SUBSCRIPTION.progress_index += 1;
        } else {
            D_SUBSCRIPTION.wb = false;
            D_SUBSCRIPTION.hideSSChart('wb');
        }

        //Blocked Applications 
        if (ss_data.app_cntrl && ss_data.app_cntrl.data.count > 0) {
            D_SUBSCRIPTION.app_cntrl = true;
            D_SUBSCRIPTION.progress_index += 1;
        } else {
            D_SUBSCRIPTION.app_cntrl = false;
            D_SUBSCRIPTION.hideSSChart('app_cntrl');
        }

        //GAV
        if (ss_data.gav && ss_data.gav.data.count > 0) {
            D_SUBSCRIPTION.gav = true;
            D_SUBSCRIPTION.progress_index += 1;
        } else {
            D_SUBSCRIPTION.gav = false;
            D_SUBSCRIPTION.hideSSChart('gav');
        }

        //IPS
        if (ss_data.ips && ss_data.ips.data.count > 0) {
            D_SUBSCRIPTION.ips = true;
            D_SUBSCRIPTION.progress_index += 1;
        } else {
            D_SUBSCRIPTION.ips = false;
            D_SUBSCRIPTION.hideSSChart('ips');
        }

        //APT
        if (ss_data.apt && ss_data.apt.data.count > 0) {
            D_SUBSCRIPTION.apt = true;
            D_SUBSCRIPTION.progress_index += 1;
        } else {
            D_SUBSCRIPTION.apt = false;
            D_SUBSCRIPTION.hideSSChart('apt');
        }

        //Botnet
        if (ss_data.botnet && ss_data.botnet.data.count > 0) {
            D_SUBSCRIPTION.botnet = true;
            D_SUBSCRIPTION.progress_index += 1;
        } else {
            D_SUBSCRIPTION.botnet = false;
            D_SUBSCRIPTION.hideSSChart('botnet');
        }

        //RED
        if (ss_data.red && ss_data.red.data.count > 0) {
            D_SUBSCRIPTION.red = true;
            D_SUBSCRIPTION.progress_index += 1;
        } else {
            D_SUBSCRIPTION.red = false;
            D_SUBSCRIPTION.hideSSChart('red');
        }

        //DLP
        if (ss_data.dlp && ss_data.dlp.data.count > 0) {
            D_SUBSCRIPTION.dlp = true;
            D_SUBSCRIPTION.progress_index += 1;
        } else {
            D_SUBSCRIPTION.dlp = false;
            D_SUBSCRIPTION.hideSSChart('dlp');
        }

        //spam
        if (ss_data.spam && ss_data.spam.data.count > 0) {
            D_SUBSCRIPTION.spam = true;
            D_SUBSCRIPTION.progress_index += 1;
        } else {
            D_SUBSCRIPTION.spam = false;
            D_SUBSCRIPTION.hideSSChart('spam');
        }
    },

    showProgress: function (progress_level) {
        var percent_complete = (progress_level / D_SUBSCRIPTION.progress_index) * 100;
        $("#progress .bar").css('width', percent_complete + '%');
    },

    showSSChart: function (div, series) {
        var chart = div + '_chart';
        WGRD.showUIElements(true, ['#' + div + '_dashboard']);
        showChartLoading(chart);
        showChart(div + '_chart');
        plotChart(series, div + '_chart', true);
    },

    hideSSChart: function (div) {
        WGRD.showUIElements(false, ['#' + div + '_dashboard']);
    },

    doResize: function () {
        var resizePlots = D_SUBSCRIPTION.report_plots;
        var plot, ss, chart_area_width;

        for (plot in resizePlots) {
            if (resizePlots.hasOwnProperty(plot)) {
                ss = plot.slice(0, plot.search('_chart_graph'));
                chart_area_width = $('#' + ss + '_chart_area').width();
                if (resizePlots[plot]) {
                    $('#' + plot).width(chart_area_width * 0.95);
                    resizePlots[plot].replot();
                }
            }
        }
    },

    getDisplayNumberFormat: function (num) {
        if (num < 1000) {
            return num;
        }

        var num_k, num_m, num_b, num_t;
        var result;

        num_k = num / 1000; //Thousand
        result = D_SUBSCRIPTION.checkDisplayExecEnd(num_k);
        if (result === undefined) {
            num_m = num / 1000000; //Million
            result = D_SUBSCRIPTION.checkDisplayExecEnd(num_m);
            if (result === undefined) {
                num_b = num / 1000000000; //Billion
                result = D_SUBSCRIPTION.checkDisplayExecEnd(num_b);
                if (result === undefined) {
                    num_t = num / 1000000000000; //Trillion
                    result = D_SUBSCRIPTION.checkDisplayExecEnd(num_t);
                    if (result === undefined) {
                        return D_SUBSCRIPTION.getDisplayNum(num_t).toString() + D_SS_UNIT_TRILLION;
                    }
                    return D_SUBSCRIPTION.getDisplayNum(result).toString() + D_SS_UNIT_TRILLION;
                }
                return D_SUBSCRIPTION.getDisplayNum(result).toString() + D_SS_UNIT_BILLION;
            }
            return D_SUBSCRIPTION.getDisplayNum(result).toString() + D_SS_UNIT_MILLION;
        }
        return D_SUBSCRIPTION.getDisplayNum(result).toString() + D_SS_UNIT_THOUSAND;
    },

    checkDisplayExecEnd: function (num) {
        var temp_num = num / 100;
        return temp_num < 10 ? num : undefined;
    },

    getDisplayNum: function (num) {
        num = parseFloat(num);
        return num < 100 ? (num < 10 ? Math.floor(num * 100) / 100 : Math.floor(num * 10) / 10) : Math.floor(num);
    },

    toggleProgressBar: function (b) {
        if (b) {
            $('#pdf_link').css('cursor', 'default');
            $("#progress").show();
        } else {
            $("#progress").hide();
            $('#pdf_link').css('cursor', 'pointer');
        }
    },

    resetProgressBar: function () {
        D_SUBSCRIPTION.report_plots = [];
        $("#progress .bar").css('width', 0);
        D_SUBSCRIPTION.toggleProgressBar(true);
        var percent_complete = (1 / 5) * 100;
        $("#progress .bar").css('width', percent_complete + '%');
    }
};

$(document).ready(D_SUBSCRIPTION.init);
