$.extend({
    getUrlVars: function () {
        var vars = [], hash;
        var hashes = window.location.href.slice(window.location.href.indexOf('?') + 1).split('&');
        var i;
        for (i = 0; i < hashes.length; i++) {
            hash = hashes[i].split('=');
            vars.push(hash[0]);
            vars[hash[0]] = decodeURIComponent(hash[1]);
        }
        return vars;
    },
    getUrlVar: function (name) {
        var urlvar = $.getUrlVars()[name];
        if (!urlvar) {
            return null;
        }
        var hashidx = urlvar.indexOf('#');
        if (hashidx > 0) {
            return urlvar.substring(0, hashidx);
        }
        return urlvar;
    },
    /* -=-=-=- Date manipulation -=-=-=- */
    getDateUTCOffsetString: function (dateval, tz) {
        /* If the user is requesting logs in utc time, leave time as is and append UTC tz stamp */
        if (tz === 'utc') {
            return " UTC+00:00";
        }
        /* If the user is requesting logs in local time, convert the offset to UTC+00:00 format */
        var d = new $.jsDate(dateval);
        var offset = d.getTimezoneOffset();
        var hours = Math.abs(offset / 60);
        var minutes = Math.abs(offset % 60);
        d.setHours(hours);
        d.setMinutes(minutes);
        var tzfmt = "UTC%H:%M";
        if (offset > 0) {
            tzfmt = "UTC-%H:%M";
        }
        return d.strftime(tzfmt);
    },
    getDateDisplay: function (value, show_seconds, tz) {
        if (value === null) {
            return '';
        }
        /* If the user is requesting logs in utc time, strip the GMT stamp */
        if (tz === 'utc') {
            return value.replace(" GMT", "");
        }
        /* If the date doesn't have a GMT timestamp, server doesn't return UTC time, return it as is */
        if (value.indexOf('GMT') < 0) {
            return value;
        }

        /* If the string is just 'GMT' after stripping white space, return an empty string */
        if ($.trim(value) === 'GMT') {
            return '&nbsp;';
        }

        /* If the user is requesting logs in local time, format into local time */
        var d = new $.jsDate(value);
        var fmt = '%Y-%m-%d %H:%M:%S';
        if (show_seconds === false) {
            fmt = '%Y-%m-%d %H:%M';
        }

        return d.strftime(fmt);
    },
    getDateRange: function (begin_time, end_time) {
        if (begin_time === null || end_time === null) {
            return '';
        }
        /* If the date doesn't have a GMT timestamp, server doesn't return UTC time, return it as is */
        if (begin_time.indexOf('GMT') < 0) {
            begin_time += ' GMT';
        }
        if (end_time.indexOf('GMT') < 0) {
            end_time += ' GMT';
        }

        /* If the user is requesting logs in local time, format into local time */
        var b_d = new $.jsDate(begin_time);
        var e_d = new $.jsDate(end_time);
        /* Compare dates */
        var fmt = '%Y-%m-%d';
        var str_b = b_d.strftime(fmt);
        var str_e = e_d.strftime(fmt);
        var datematch = false;
        if (str_b === str_e) {
            datematch = true;
        }
        fmt = '%Y-%m-%d %I:%M %p';
        str_b = b_d.strftime(fmt);
        if (datematch) {
            fmt = '%I:%M %p';
        }
        str_e = e_d.strftime(fmt);

        return str_b + " - " + str_e;
    },
    getDateLocalToSecs: function (datetime) {
        /* Convert local time to unix time */
        var d1 = new $.jsDate(datetime);
        return parseInt(d1.getUnix(), 10);
    },
    /**
    * Converts an HSL color value to RGB. Conversion formula
    * adapted from http://en.wikipedia.org/wiki/HSL_color_space.
    * Assumes h, s, and l are contained in the set [0, 1] and
    * returns r, g, and b in the set [0, 255].
    *
    * @param   Number  h       The hue
    * @param   Number  s       The saturation
    * @param   Number  l       The lightness
    * @return  Array           The RGB representation
    */
    hslToRgb: function (h, s, l) {
        var r, g, b;
        function hue2rgb(p, q, t) {
            if (t < 0) {
                t += 1;
            }
            if (t > 1) {
                t -= 1;
            }
            if (t < 1 / 6) {
                return p + (q - p) * 6 * t;
            }
            if (t < 1 / 2) {
                return q;
            }
            if (t < 2 / 3) {
                return p + (q - p) * (2 / 3 - t) * 6;
            }
            return p;
        }
        if (s === 0) {
            r = g = b = l; // achromatic
        } else {
            var q = l < 0.5 ? l * (1 + s) : l + s - l * s;
            var p = 2 * l - q;
            r = hue2rgb(p, q, h + 1 / 3);
            g = hue2rgb(p, q, h);
            b = hue2rgb(p, q, h - 1 / 3);
        }

        return [r * 255, g * 255, b * 255];
    },
    get_hsl_colors: function (spacer) {
        var colors = [];
        var l = 0.0;
        // clr_extended1 .. clr_extended10, clr_accent2
        var hsl_colors = [[127, 165, 112], [132, 158, 87], [138, 240, 60], [234, 94, 104], [215, 135, 110], [13, 213, 131], [21, 225, 136], [31, 118, 70], [84, 95, 115], [109, 108, 97], [167, 61, 127]];
        var i, j, rgbar, rgb;
        for (i = 0; i < hsl_colors.length; i++) {
            colors[i] = [];
            // Iterate on Lum, throw out first 2 and last 2.9 values
            for (j = hsl_colors[i][2] - 30; j < hsl_colors[i][2] + 30; j++) {
                if (j % spacer) {
                    continue;
                }
                l = j / 240;
                rgbar = $.hslToRgb(hsl_colors[i][0] / 240, hsl_colors[i][1] / 240, l);
                rgb = 'rgb(' + parseInt(rgbar[0], 10) + ', ' + parseInt(rgbar[1], 10) + ', ' + parseInt(rgbar[2], 10) + ')';
                colors[i].push(rgb);
            }
        }
        return colors;

    },
    commaify: function (n) {
        var ret = '';
        var num = '';
        if (n === undefined || n === null || isNaN(n)) {
            return ret;
        }
        num = num + n; // n.toString() triggers intermittent type error in Safari 6
        var i;
        for (i = num.length - 1; i >= 0; i--) {
            if (i < num.length - 1 && (num.length - i - 1) % 3 === 0) {
                ret = "," + ret;
            }
            ret = num.charAt(i) + ret;
        }
        return ret;
    },
    formatBytes: function (bytes, gb, mb, kb, b, p) {
        var start = bytes / 1024;
        var ret = '';
        var GB = (gb && gb !== '') ? gb : "GB";
        var MB = (mb && mb !== '') ? mb : "MB";
        var KB = (kb && kb !== '') ? kb : "KB";
        var B = (b && b !== '') ? b : "bytes";
        var f = p || 0;

        if (start > 1) {
            var start1 = start / 1024;
            if (start1 > 1) {
                var start2 = start1 / 1024;
                if (start2 > 1) {
                    ret = parseFloat(start2, 10).toFixed(f) + " " + GB;
                } else {
                    ret = parseFloat(start1, 10).toFixed(f) + " " + MB;
                }
            } else {
                ret = parseFloat(start, 10).toFixed(f) + " " + KB;
            }
        } else {
            ret = parseFloat(bytes, 10).toFixed(f) + " " + B;
        }

        return ret;
    },
    formatBandwidth: function (bps) {
        var divisor = 1;
        var label = " bps";
        if (bps > 1000000) {
            divisor = 1000 * 1000;
            label = " Mbps";
        } else if (bps > 1000) {
            divisor = 1000;
            label = " Kbps";
        }
        return $.commaify(parseInt(bps / divisor, 10)) + label;
    }
});

$.extend($.fn.fmatter, {
    dateFormatter : function (cellvalue, options, rowdata) {
        var urlTz = $.getUrlVar('tz');
        var retval = $.getDateDisplay(cellvalue, true, urlTz);
        return retval;
    }
});
