/*global L_SERVERS, S_LOG_GROUPS, S_LOG_VPNS, WGMAP_MERCATOR, S_USER_MODE, NODEPOPOVER, DEVICE_WIZ, HELP_LINK_OVERRIDE:true, S_CONTROL_UNKNOWN_DEVICES, S_CONTROL_STATE_CONNECTED, S_CONTROL_STATE_DISCONNECTED, S_CONTROL_STATE_DISABLED, S_CONTROL_STATE_BACKUPMASTER, S_REMOVE_DEVICE_TITLE, S_REMOVE_DEVICE_CONFIRM_MSG, S_REMOVE, S_REMOVE_FC, S_REMOVE_FC_MEMBER, S_REMOVE_MGS_1, S_REMOVE_MGS_2, S_REMOVE_MGS_3, S_LOGGING_DISABLED_MSG, S_LOGGING_NO_MSG, S_LOGGING_YES_MSG, S_REMOVE_DEVICE_ERROR, checkLoginPageRedirect, compareVersion, selected_tab, view_group_tab_perm, view_server_tab_perm, user_has_only_ao_role, anonymization_enabled, user_has_only_vl_role, S_ANONYMIZED_MODE_MSG, has_ao_and_vl_role */
var S_LOG_DEVICES = {
    ADD_DEVICE: 'add',
    EDIT_DEVICE: 'edit',
    ispopup: 0,
    columns: null,
    lastData: {},
    viewMode: 'list',
    featuresView: ['ac_expiration', 'apt_expiration', 'av_expiration', 'dc_expiration', 'dlp_expiration',
                    'ips_expiration', 'lse_expiration', 'red_expiration', 'sb_expiration', 'wb_expiration'
        ],
    filtered_columns: ['display_name', 'active', 'mode', 'ip_address', 'sn_disp', 'version', 'type_name',
                    'control.cpu_util_1', 'mem_pct', 'control.uptime', 'fk_expiration',
                    'ac_expiration', 'apt_expiration', 'av_expiration', 'dc_expiration', 'dlp_expiration',
                    'ips_expiration', 'lse_expiration', 'red_expiration', 'sb_expiration', 'wb_expiration'        ],
    formatted_columns: ['active', 'mode', 'ip_address', 'control.cpu_util_1', 'mem_pct', 'control.uptime', 'fk_expiration',
                    'ac_expiration', 'apt_expiration', 'av_expiration', 'dc_expiration', 'dlp_expiration',
                    'ips_expiration', 'lse_expiration', 'red_expiration', 'sb_expiration', 'wb_expiration'
        ],
    //Hide all except APP_CONTROL, DIMENSION_COMMAND and LIVESECURITY
    hideFeaturesView: ['ac_expiration', 'apt_expiration', 'av_expiration', 'dlp_expiration',
                  'ips_expiration', 'red_expiration', 'sb_expiration', 'wb_expiration'
        ],
    init: function () {
        S_LOG_DEVICES.initHelp();
        // Hide the grid and anonymization icon if user has only 'Anonymization Offier' role
        // Show an information message.
        if (user_has_only_ao_role === 1) {
            $(".de_anyonymize").hide();
            $("#ao_msg").show();
            return;
        }
        S_LOG_DEVICES.ispopup = $("#hidden_btn_select_device").length;
        S_LOG_DEVICES.initUI();
        S_LOG_DEVICES.initEvents();

        S_LOG_DEVICES.getGridColumns();
        $(".logViewTable").show();
    },

    initUI: function () {
        $("body").css('padding-bottom', '0px');
        $("#btn_clear").hide();
        $("#input_search").val('');
        WGRD.enableUIElements(false, ['#device_delete_btn']);
        var default_tab = selected_tab;
        if (window.location.hash.length > 0) {
            default_tab = window.location.hash.substring();
            window.location.hash = '';
        }
        $('#lstabs a[href=' + default_tab + ']').tab('show');
        if (view_group_tab_perm === 0 || view_server_tab_perm === 0) {
            S_USER_MODE.selected_tab = default_tab;
        }
    },

    initEvents: function () {
        $("#btn_wifi_tabs").click(function () {
            window.open("https://login.watchguard.cloudwifi.com");
        });
        $("#btn_search").click(function () {
            var data = $("#input_search").val();
            var grid = $("#grid_entities");
            var filters;

            NODEPOPOVER.closePopover();
            if (data.length === 0) {
                grid[0].p.search = false;
                filters = '';
                $("#btn_clear").hide();
            } else {
                if (S_LOG_DEVICES.columns) {
                    var rules = [];
                    var ndx = 0;
                    var col = null;
                    var cm = $("#grid_entities").getGridParam('colModel');
                    var colname = '';
                    for (ndx = 0; ndx < cm.length; ndx++) {
                        col = cm[ndx];
                        if (S_LOG_DEVICES.filtered_columns.indexOf(col.name) >= 0) {
                            colname = col.name;
                            if (S_LOG_DEVICES.formatted_columns.indexOf(colname) >= 0) {
                                colname += '_filter_txt';
                            }

                            rules.push({field: colname, op: "cn", data: data});
                        }
                    }

                    grid[0].p.search = true;
                    filters = {
                        groupOp: "OR",
                        rules: rules
                    };
                    $("#btn_export_csv").hide();
                    $("#btn_clear").show();
                }
            }
            $.extend(grid[0].p.postData, { filters: JSON.stringify(filters) });
            grid.trigger("reloadGrid", [{ page: 1, current: true }]);
            $("#input_search").focus();
        });
        $('#input_search').bind('keypress', function (e) {
            if (e.keyCode === 13) {
                $("#btn_search").click();
            }
        });
        $("#btn_clear").click(function () {
            $("#input_search").val('');
            $("#btn_search").click();
            $("#btn_export_csv").show();
        });
        $("#btn_export_csv").click(function (eo) {
            window.location = "log_devices_csv";
        });

        $('#device_delete_btn').button().click(S_LOG_DEVICES.removeDeviceAction);
        $('#device_add_btn').button().click(S_LOG_DEVICES.addDeviceAction);
        $('#device_edit_btn').button().click(S_LOG_DEVICES.editDeviceAction);

        $('#btn_refresh_tabs').button().click(function () {
            var attr = $('#btn_refresh_tabs').attr('disabled');
            if (attr !== 'true' && attr !== 'disabled') {
                S_LOG_DEVICES.doRefreshTabs();
            }
        });

        $('a[data-toggle="pill"]').on('shown', function (e) {
            if (e.target.id === "pill_list") {
                S_LOG_DEVICES.viewList();
            } else if (e.target.id === "pill_health") {
                S_LOG_DEVICES.viewHealth();
            } else if (e.target.id === "pill_features") {
                S_LOG_DEVICES.viewFeatures();
            } else if (e.target.id === "pill_map") {
                S_LOG_DEVICES.viewMap();
            }
        });

        $("body").click(function () {
            if (S_LOG_DEVICES.viewMode === 'map') {
                NODEPOPOVER.closePopover();
            }
        });

        $(window).bind('resizeEnd', S_LOG_DEVICES.doResize);

        $("#btn_unknown_nodes").click(S_LOG_DEVICES.viewUnknownNodes);
    },

    initHelp : function () {
        // Update help link based on tab selected
        $('#lstabs a[href="#tabDevices"]').click(function (e) {
            HELP_LINK_OVERRIDE = 7050;
        });
        $('#lstabs a[href="#tabGroups"]').click(function (e) {
            HELP_LINK_OVERRIDE = 7051;
            S_USER_MODE.selected_tab = "#tabGroups";
        });
        $('#lstabs a[href="#tabVpns"]').click(function (e) {
            HELP_LINK_OVERRIDE = 7049;
        });
        $('#lstabs a[href="#tabServers"]').click(function (e) {
            HELP_LINK_OVERRIDE = 7052;
        });
    },

    getGridColumns: function (complete_cb) {
        $.ajax({
            url: 'log_grid_columns?l_t=' + 'devices',
            method: 'GET',
            dataType: 'json',
            success: function (columns) {
                S_LOG_DEVICES.columns = columns;
                S_LOG_DEVICES.getGridData();
            },
            complete: function () {
                if (complete_cb) {
                    complete_cb();
                }
            }
        });
    },
    getGridData: function (complete_cb) {
        $.ajax({
            url: 'log_devices?_search=false&rows=10000&page=1&sidx=name&sord=asc',
            method: 'GET',
            dataType: 'json',
            success: function (response) {
                if (response.error) {
                    WGRD.okMessageModal(response.message, '');
                } else {
                    S_LOG_DEVICES.onGridDataReceived(S_LOG_DEVICES.columns, response);
                    if (response.control_on !== 0) {
                        $('.control-pills').show();
                        S_LOG_DEVICES.onMapDataReceived(response);
                    }
                }
            },
            complete: function () {
                if (complete_cb) {
                    complete_cb();
                }
            }
        });
    },
    viewMap: function () {
        S_LOG_DEVICES.viewMode = 'map';
        WGRD.showUIElements((S_LOG_DEVICES.unknown_devices.length > 0), ["#btn_unknown_nodes"]);
        S_LOG_DEVICES.doMapResize();

    },
    viewHealth: function () {
        S_LOG_DEVICES.viewMode = 'health';
        WGRD.showUIElements(false, ["#btn_unknown_nodes"]);
        S_LOG_DEVICES.viewToggleGrid('health');
    },
    viewFeatures: function () {
        S_LOG_DEVICES.viewMode = 'features';
        WGRD.showUIElements(false, ["#btn_unknown_nodes"]);
        S_LOG_DEVICES.viewToggleGrid('features');
    },
    viewList: function () {
        S_LOG_DEVICES.viewMode = 'list';
        WGRD.showUIElements(false, ["#btn_unknown_nodes"]);
        S_LOG_DEVICES.viewToggleGrid('list');
    },
    viewToggleGrid: function (view) {
        var listView = ['active', 'mode', 'sn_disp', 'version', 'ip_address', 'type_name'];
        var healthView = ['fk_expiration', 'control.cpu_util_1', 'mem_pct', 'control.uptime'];

        if (view === 'list') { // hide health and features col, show list col
            $("#grid_entities").jqGrid('hideCol', healthView);
            $("#grid_entities").jqGrid('hideCol', S_LOG_DEVICES.featuresView);
            $("#grid_entities").jqGrid('showCol', listView);
        } else if (view === 'health') { // hide features and list col, how health cols
            $("#grid_entities").jqGrid('hideCol', listView);
            $("#grid_entities").jqGrid('hideCol', S_LOG_DEVICES.featuresView);
            $("#grid_entities").jqGrid('showCol', healthView);
        } else if (view === 'features') {
            $("#grid_entities").jqGrid('hideCol', listView);
            $("#grid_entities").jqGrid('hideCol', healthView);
            $("#grid_entities").jqGrid('showCol', S_LOG_DEVICES.featuresView);
        }
        S_LOG_DEVICES.curWinSize = -1;
        S_LOG_DEVICES.doResize();
        NODEPOPOVER.closePopover();
    },
    colsInListView: function (hide, actual_cols) {
        if (S_LOG_DEVICES.control_on === 0) {
            if (hide) {
                actual_cols.push('mode');
            } else {
                var mode_col_index = actual_cols.indexOf('mode');
                if (mode_col_index !== -1) {
                    actual_cols.splice(mode_col_index, 1);
                }
            }
        }
        return actual_cols;
    },
    viewSizeGrid: function (winSize) {
        switch (winSize) {
        case 0:
            if (S_LOG_DEVICES.viewMode === 'list') {
                $("#grid_entities").jqGrid('hideCol', S_LOG_DEVICES.colsInListView(true, ['type_name', 'version', 'ip_address', 'sn_disp']));
                $("#grid_entities").jqGrid('showCol', S_LOG_DEVICES.colsInListView(false, ['active', 'mode']));
            } else if (S_LOG_DEVICES.viewMode === 'health') {
                $("#grid_entities").jqGrid('hideCol', ['active', 'mode', 'fk_expiration', 'control.uptime']);
                $("#grid_entities").jqGrid('showCol', ['control.cpu_util_1', 'mem_pct']);
            } else if (S_LOG_DEVICES.viewMode === 'features') {
                $("#grid_entities").jqGrid('hideCol', S_LOG_DEVICES.hideFeaturesView);
                $("#grid_entities").jqGrid('showCol', ['dc_expiration', 'lse_expiration']);
            }
            break;
        case 1:
            if (S_LOG_DEVICES.viewMode === 'list') {
                $("#grid_entities").jqGrid('hideCol', S_LOG_DEVICES.colsInListView(true, ['sn_disp', 'version', 'type_name']));
                $("#grid_entities").jqGrid('showCol', S_LOG_DEVICES.colsInListView(false, ['active', 'mode', 'ip_address']));
            } else if (S_LOG_DEVICES.viewMode === 'health') {
                $("#grid_entities").jqGrid('hideCol', ['active', 'mode', 'fk_expiration']);
                $("#grid_entities").jqGrid('showCol', ['control.cpu_util_1', 'mem_pct', 'control.uptime']);
            } else if (S_LOG_DEVICES.viewMode === 'features') {
                $("#grid_entities").jqGrid('hideCol', S_LOG_DEVICES.hideFeaturesView);
                $("#grid_entities").jqGrid('showCol', ['dc_expiration', 'lse_expiration']);
            }
            break;
        case 2:
            if (S_LOG_DEVICES.viewMode === 'list') {
                $("#grid_entities").jqGrid('hideCol', S_LOG_DEVICES.colsInListView(true, ['type_name']));
                $("#grid_entities").jqGrid('showCol', S_LOG_DEVICES.colsInListView(false, ['active', 'mode', 'ip_address', 'sn_disp', 'version']));
            } else if (S_LOG_DEVICES.viewMode === 'health') {
                $("#grid_entities").jqGrid('hideCol', ['active', 'mode']);
                $("#grid_entities").jqGrid('showCol', ['control.cpu_util_1', 'mem_pct', 'control.uptime', 'fk_expiration']);
            } else if (S_LOG_DEVICES.viewMode === 'features') {
                $("#grid_entities").jqGrid('hideCol', S_LOG_DEVICES.hideFeaturesView);
                $("#grid_entities").jqGrid('showCol', ['ac_expiration', 'dc_expiration', 'lse_expiration']);
            }
            break;
        case 3:
            if (S_LOG_DEVICES.viewMode === 'list') {
                $("#grid_entities").jqGrid('hideCol', S_LOG_DEVICES.colsInListView(true, []));
                $("#grid_entities").jqGrid('showCol', S_LOG_DEVICES.colsInListView(false, ['active', 'mode', 'ip_address', 'sn_disp', 'version', 'type_name']));
            } else if (S_LOG_DEVICES.viewMode === 'health') {
                $("#grid_entities").jqGrid('showCol', ['active', 'mode', 'fk_expiration', 'control.cpu_util_1', 'mem_pct', 'control.uptime']);
            } else if (S_LOG_DEVICES.viewMode === 'features') {
                $("#grid_entities").jqGrid('showCol', S_LOG_DEVICES.featuresView);
            }
            break;
        }
    },
    viewUnknownNodes: function (eo) {
        var d = { 'id': 'Unknown', 'is_unknown_devices': true, 'entities': S_LOG_DEVICES.unknown_devices, 'count': S_LOG_DEVICES.unknown_devices.length, 'name': S_CONTROL_UNKNOWN_DEVICES };
        NODEPOPOVER.popover("wgmap", d, 0);
        eo.stopPropagation();
    },
    pctbarFormat: function (percent, color_class) {
        return '<div class="pctbar progress-inverse pctbar" title="' + percent + '%"><div class="' + color_class
            + ' pctbar-bar" style="width:' + percent + '%;"></div></div>'
            + '<div style="width:50%;margin-bottom:1px;" title="' + percent + '%">' + percent + '%</div>';
    },
    chartFormatter: function (cellvalue, options, rowObject) {
        var div = '';
        var color_class = 'pctbar_cpumem';
        var idx = 0;
        if (options.colModel.name === 'control.cpu_util_1' && rowObject.control && rowObject.control.cpu_util_1 !== null) {
            if (rowObject.members) {
                rowObject.control.cpu_util_1_filter_txt = '';
                for (idx = 0; idx < rowObject.members.length; idx++) {
                    if (rowObject.members[idx].control.cpu_util_1 === null) {
                        continue;
                    }
                    div += S_LOG_DEVICES.pctbarFormat(rowObject.members[idx].control.cpu_util_1, color_class);
                    rowObject.control.cpu_util_1_filter_txt += rowObject.members[idx].control.cpu_util_1 + '%';
                }
            } else {
                div = S_LOG_DEVICES.pctbarFormat(rowObject.control.cpu_util_1, color_class);
                rowObject.control.cpu_util_1_filter_txt = rowObject.control.cpu_util_1 + '%';
            }
        } else if (options.colModel.name === 'mem_pct' && rowObject.control && rowObject.control.mem_total !== null) {
            if (rowObject.members) {
                rowObject.mem_pct_filter_txt = '';
                for (idx = 0; idx < rowObject.members.length; idx++) {
                    if (rowObject.members[idx].mem_pct === null) {
                        continue;
                    }
                    div += S_LOG_DEVICES.pctbarFormat(rowObject.members[idx].mem_pct, color_class);
                    rowObject.mem_pct_filter_txt += rowObject.members[idx].mem_pct + '%';
                }
            } else {
                div = S_LOG_DEVICES.pctbarFormat(rowObject.mem_pct, color_class);
                rowObject.mem_pct_filter_txt = rowObject.mem_pct + '%';
            }
        }

        return div;
    },
    uptimeFormatter: function (cellvalue, options, rowObject) {
        var div = '';
        var idx = 0;
        var fmt = '';
        if (options.colModel.name === 'control.uptime' && rowObject.control && rowObject.control.uptime !== null) {
            if (rowObject.members) {
                rowObject.control.uptime_filter_txt = '';
                for (idx = 0; idx < rowObject.members.length; idx++) {
                    if (rowObject.members[idx].mem_pct === null) {
                        continue;
                    }
                    fmt = WGRD.timeFormatter(rowObject.members[idx].control.uptime);
                    div += '<div class="pull-left" title="' + fmt + '">' + fmt + '</div>';
                    div += '<br />';
                    rowObject.control.uptime_filter_txt += fmt;
                }
            } else {
                if (cellvalue === 0) {
                    return '';
                }
                fmt = WGRD.timeFormatter(cellvalue);
                div = '<div class="pull-left" title="' + fmt + '">' + fmt + '</div>';
                rowObject.control.uptime_filter_txt = fmt;
            }
        }
        return div;
    },
    _clusterMemberFormatter : function (rowObject, feature) {
        var members = rowObject.members;
        var expiration_text = [];
        var i,
            left,
            expire_date,
            feature_info,
            expiration;
        for (i = 0; i < members.length; i++) {
            if (feature !== undefined) {
                feature_info = members[i][feature];
                if (feature_info === undefined || feature_info === '') {
                    continue;
                }
                left = feature_info.left;
                expire_date = feature_info.expiration.replace('T', ' ');
            } else {
                expiration = members[i].fk_expiration;
                if (expiration === undefined) {
                    continue;
                }
                expire_date = expiration.replace('T', ' ');
                left = members[i].fk_left;
            }
            expiration_text.push(S_LOG_DEVICES._fkFormatHelper(expire_date, left));
        }
        return expiration_text;
    },
    fkFormatter: function (cellvalue, options, rowObject) {
        var expire_date = '';
        var cluster_expiration = [];
        var i;
        if (rowObject.is_cluster === 1) {
            cluster_expiration = S_LOG_DEVICES._clusterMemberFormatter(rowObject);
            for (i = 0; i < cluster_expiration.length; i++) {
                expire_date += cluster_expiration[i];
            }
            rowObject.fk_expiration_filter_txt = $(cluster_expiration[0]).text();
        } else {
            if (cellvalue === '' || cellvalue === undefined) {
                return '';
            }
            var left = rowObject.fk_left;
            expire_date = rowObject.fk_expiration.replace('T', ' ');
            expire_date = S_LOG_DEVICES._fkFormatHelper(expire_date, left);
            rowObject.fk_expiration_filter_txt = $(expire_date).text();
        }

        return expire_date;
    },
    _fkFormatHelper: function (expire_date, left) {
        expire_date = expire_date.replace('Z', ' GMT');
        expire_date = $.getDateDisplay(expire_date);
        expire_date = expire_date.substring(0, expire_date.indexOf(' '));

        var expire_class,
            expire_text = expire_date;
        if (left >= 90) {
            expire_class = 'fk';
        } else if (left > 30 && left < 90) {
            expire_class = "fk-expire90";
        } else if (left > 0) {
            expire_class = "fk-expire30";
        } else {
            expire_class = "fk-expired";
        }
        return '<div class="' + expire_class + '" title="' + expire_text + '">' + expire_text + '</div>';
    },
    featuresFormatter: function (cellvalue, options, rowObject, feature) {
        var expire_date = '';
        var cluster_expiration = [];
        var i;
        var feature_info = rowObject[feature + '_obj'];
        if (feature_info  === '' || feature_info === undefined) {
            return '';
        }
        var left = feature_info.left;
        var feature_expiration = feature_info.expiration;
        var filter_column_name = feature;

        if (rowObject.is_cluster === 1) {
            cluster_expiration = S_LOG_DEVICES._clusterMemberFormatter(rowObject, feature + '_obj');
            for (i = 0; i < cluster_expiration.length; i++) {
                expire_date += cluster_expiration[i];
            }
            rowObject[filter_column_name] = $(cluster_expiration[0]).text();
        } else {
            expire_date = feature_expiration.replace('T', ' ');
            expire_date = S_LOG_DEVICES._fkFormatHelper(expire_date, left);
            rowObject[filter_column_name] = $(expire_date).text();
        }

        return expire_date;
    },
    versionSortType: function (cellvalue, options) {
        //Get version string from div, higher version for cluster
        if (options.is_cluster === 1) {
            var divs = cellvalue.split('<br />');
            var v1 = $(divs[0]).text(), v2 = $(divs[1]).text();
            return compareVersion(v1, v2) > 0 ? v1 : v2;
        }
        return $(cellvalue).text();
    },
    versionSortFunc: function (a, b, direction) {
        //direction is numeric 1 and -1 for ascending and descending order
        if (direction === undefined) {
            direction = 1;
        }
        var val = compareVersion(a, b);
        if (val !== 0) {
            return val > 0 ? direction : -direction;
        }
        return 0;
    },
    onGridDataReceived: function (columns, data) {

        var idx = 0;
        for (idx = 0; idx < data.rows.length; idx++) {
            data.rows[idx].mode_filter_txt = $(data.rows[idx].mode).text();
            data.rows[idx].active_filter_txt = $(data.rows[idx].active).text();
            data.rows[idx].ip_address_filter_txt = $(data.rows[idx].ip_address).text();
        }

        if ($("#grid_entities")[0].grid) {
            $("#grid_entities").clearGridData();
            // If already initialized, load the new data and return
            $("#grid_entities").setGridParam({
                data: data.rows
            }).trigger("reloadGrid");

            return;
        }

        S_LOG_DEVICES.control_on = data.control_on;
        // Unload the grid and then recreate it
        $("#grid_entities").GridUnload("#grid_entities");

        var padleft = parseInt($("#grid_parent").css('margin-left'), 10);
        var grid_width = $("#grid_parent").width() - padleft * 2;

        $("#grid_entities").jqGrid({
            datatype: 'jsonstring',
            data: data.rows,
            mtype: 'GET',
            colNames: columns.col_names,
            colModel: columns.col_model,
            pager: '#pager_entities',
            pagerpos: 'right',
            viewrecords: true,
            recordpos: 'left',
            rowNum: 100,
            rowList: [25, 100, 250, 500],
            altRows: true,
            altclass: 'gridAltRow',
            sortname: 'name',
            ignoreCase: true,
            sortorder: 'asc',
            caption: '',
            height: 'auto',
            width: grid_width,
            loadComplete: function (data) {
                if (data === null) {
                    $('#error_msg').show();
                    $('#log_devices').hide();
                }
                $('.tree-leaf', $(this)).css('width', '0px');
                S_LOG_DEVICES.doResize();
                if (data !== undefined) {
                    S_LOG_DEVICES.lastData = data;
                    S_LOG_DEVICES.onMapDataReceived(data);
                }
                S_LOG_DEVICES.toggleRemoveBtn();
                S_LOG_DEVICES.toggleEditBtn();
                if ((has_ao_and_vl_role === 1 || user_has_only_vl_role === 1) && anonymization_enabled === 1) {
                    $("#ao_msg").text(S_ANONYMIZED_MODE_MSG)
                                .show();
                    $('.devices_namelink').removeAttr('href')
                                          .css('border', 'none');
                }
            },
            loadError: function (xhr, status, error) {
                if (!checkLoginPageRedirect(xhr, status, error)) {
                    WGRD.okMessageModal(status, '');
                }
            },
            onSelectRow: function (rowid, status, e) {
                S_LOG_DEVICES.toggleRemoveBtn();
                S_LOG_DEVICES.toggleEditBtn();
            }
        }).navGrid("#pager_entities", { refresh: false, search: false, edit: false, add: false, del: false }, {}, { width: 350 }, {});

        var searchstring = $("#input_search").val();
        if (searchstring !== '') {
            $("#btn_search").click();
        }

        $("#grid_entities").setColProp('control.cpu_util_1', { formatter: S_LOG_DEVICES.chartFormatter });
        $("#grid_entities").setColProp('mem_pct', { formatter: S_LOG_DEVICES.chartFormatter });
        $("#grid_entities").setColProp('fk_expiration', { formatter: S_LOG_DEVICES.fkFormatter});
        $.each(S_LOG_DEVICES.featuresView, function (index, value) {
            $("#grid_entities").setColProp(value, { formatter: function (cellvalue, options, rowObject) {
                return S_LOG_DEVICES.featuresFormatter(cellvalue, options, rowObject, value);
            }});
        });
        $("#grid_entities").setColProp('control.uptime', { formatter: S_LOG_DEVICES.uptimeFormatter });
        $("#grid_entities").setColProp('version', { sorttype: S_LOG_DEVICES.versionSortType, sortfunc: S_LOG_DEVICES.versionSortFunc });

        if (S_LOG_DEVICES.ispopup) {
            // When in popup mode
            $("#grid_entities").jqGrid('hideCol', 'active');
            $("#grid_entities").jqGrid('hideCol', 'type_name');
        }
        $("#grid_entities").setColProp('name', {
            sorttype: function (cellvalue, options, rowdata) {
                return options.display_name.toLowerCase();
            }
        }).trigger("reloadGrid");

        //Load data for servers tab after devices tab has been populated,
        //this is done to wait for the session log_srv_list to get initialized before the 
        //control returns to the client
        L_SERVERS.getGridData();
    },

    onMapDataReceived: function (data) {
        var nodes = [];
        var idx = 0;
        var row = {};
        var longitude = 0;
        var latitude = 0;
        var control_status = 0;
        var visibility_status = 0;
        var active_status = 0;
        var bUnknownLocation = false;
        var node = {};

        S_LOG_DEVICES.unknown_devices = [];
        for (idx = 0; idx < data.rows.length; idx++) {
            row = data.rows[idx];
            bUnknownLocation = false;
            if (row.control) {
                latitude = row.control.latitude;
                longitude = row.control.longitude;
                if (longitude === null || latitude === null || (latitude === 0 && longitude === 0)) {
                    if (row.geoip_info && row.geoip_info.latitude) {
                        latitude = row.geoip_info.latitude;
                        longitude = row.geoip_info.longitude;
                    } else {
                        bUnknownLocation = true;
                    }
                }
                control_status = 0;
                if (!row.control.enabled || row.control.sample_time === null) {
                    control_status = -1;
                } else if (row.control.connected === 1) {
                    control_status = 1;
                } else if (row.control.role === 'backup master') {
                    control_status = 1;
                }
                visibility_status = -1;
                if (row.visibility) {
                    if (row.visibility.connected === 1) {
                        visibility_status = 1;
                    } else if (row.visibility.accept_logs && !row.visibility.connected) {
                        visibility_status = 0;
                    }
                }
                active_status = control_status && visibility_status;
                if (control_status === -1 && visibility_status === -1) {
                    active_status = 2;
                }
                node = { 'status': active_status, 'longlat': [longitude, latitude], 'name': row.display_name, 'id': row.id, 'logging': row.active, 'managed': row.mode };
                if (bUnknownLocation) {
                    S_LOG_DEVICES.unknown_devices.push(node);
                } else {
                    nodes.push(node);
                }
            }
        }
        var mapdata = {
            'nodes': nodes,
            'links': []
        };

        if (WGMAP_MERCATOR.svg === null) {
            WGMAP_MERCATOR.countryColor = { 'stroke': 'rgba(237,237,237,0.2)', 'fill': '#646464', 'strokewidth': '0.15px' };
            //WGMAP_MERCATOR.waterColor = { 'stroke': 'White', 'fill': 'rgba(120,120,120,0.2)', 'strokewidth': '0px' };

            var width = $("#tabDevices").width();
            var height = $(window).height();
            var pos = $("#wgmap").offset();
            var margin = 5;
            height = height - pos.top - margin;

            WGMAP_MERCATOR.initMap("wgmap", mapdata, width, height, false);
            NODEPOPOVER.customPopover = S_LOG_DEVICES.onMapPopover;
        } else {
            WGMAP_MERCATOR.draw(mapdata);
        }
        S_LOG_DEVICES.doMapResize();

        $("#btn_unknown_nodes a").text(S_CONTROL_UNKNOWN_DEVICES + ' [' + S_LOG_DEVICES.unknown_devices.length + ']');
        $("#btn_unknown_nodes").hide();
        if (S_LOG_DEVICES.unknown_devices.length > 0 && S_LOG_DEVICES.viewMode === 'map') {
            $("#btn_unknown_nodes").show();
        }
    },
    doMapResize: function () {
        var width = $("#tabDevices").width();
        var height = $(window).height();
        var pos = $("#wgmap").offset();
        var margin = 9;

        if (WGMAP_MERCATOR.projection === null) {
            return;
        }
        height = height - pos.top - margin;
        WGMAP_MERCATOR.width = width;
        WGMAP_MERCATOR.height = height;
        $("#wgmap").width(WGMAP_MERCATOR.width);
        $("#wgmap").height(WGMAP_MERCATOR.height);

        WGMAP_MERCATOR.projection
            .translate([WGMAP_MERCATOR.width / 2, WGMAP_MERCATOR.height / 2])
            .scale((WGMAP_MERCATOR.width - 1) / 2 / Math.PI);

        WGMAP_MERCATOR.draw();

        WGMAP_MERCATOR.svg
            .attr("width", WGMAP_MERCATOR.width)
            .attr("height", WGMAP_MERCATOR.height);
    },
    _parseActiveState: function (value) {
        var classname = 'devices_active';
        var state = S_CONTROL_STATE_CONNECTED;
        if (value) {
            if (value.enabled && !value.connected && value.role === 'backup master') {
                classname = 'devices_nodisabled';
                state = S_CONTROL_STATE_BACKUPMASTER;
            } else if (value.enabled && !value.connected) {
                classname = 'devices_noactive';
                state = S_CONTROL_STATE_DISCONNECTED;
            } else if (value.disabled) {
                classname = 'devices_nodisabled';
                state = S_CONTROL_STATE_DISABLED;
            }
        } else {
            classname = 'devices_nodisabled';
            state = S_CONTROL_STATE_DISABLED;
        }
        return '<span class="' + classname + '">' + state + '</span>';
    },
    _getColName: function (colname) {
        var cm = $("#grid_entities").getGridParam('colModel');
        var cn = $("#grid_entities").getGridParam('colNames');
        var idx = 0;
        for (idx = 0; idx < cm.length; idx++) {
            if (cm[idx].name === colname) {
                return cn[idx];
            }
        }
        return '';
    },
    _onMapPopoverList: function (nodes, title, titlediv, contentdiv) {
        var content = '';
        var idx = 0;
        var node = {};
        content += '<table class="table table-condensed table-noborder">';
        content += '<tr><th width="70%">' + S_LOG_DEVICES._getColName('name') + '</th><th>' + S_LOG_DEVICES._getColName('active') + '</th><th>' + S_LOG_DEVICES._getColName('mode') + '</th></tr>';
        for (idx = 0; idx < nodes.length; idx++) {
            node = nodes[idx];
            content += '<tr><td><a href="/control/device?sn=' + node.id + '">' + node.name + '</a></td><td>' + node.logging + '</td><td>' + node.managed + '</td><td></tr>';
        }
        content += '</table>';

        $(titlediv).html(title);
        $(contentdiv).html(content);
    },
    onMapPopover: function (titlediv, contentdiv, d) {
        var idx = 0;
        var row = {};
        var content = '';
        var color_class = 'pctbar_cpumem';
        var title = d.name;
        if (d.is_unknown_devices) {
            S_LOG_DEVICES._onMapPopoverList(S_LOG_DEVICES.unknown_devices, title, titlediv, contentdiv);
            return;
        }
        if (d.nodes && d.nodes.length > 1) {
            S_LOG_DEVICES._onMapPopoverList(d.nodes, title, titlediv, contentdiv);
            return;
        }

        for (idx = 0; idx < S_LOG_DEVICES.lastData.rows.length; idx++) {
            row = S_LOG_DEVICES.lastData.rows[idx];
            if (row.display_name === d.name) {
                if (!row.is_cluster || (row.members && row.members.length === 1)) {
                    // Single appliance
                    content = '<table class="popup_table" style="width:80%;">';
                    content += '<tr><td style="width:50%;">' + S_LOG_DEVICES._getColName('active') + '</td>';
                    content += '<td>' + row.active + '</td></tr>';
                    content += '<tr><td>' + S_LOG_DEVICES._getColName('mode') + '</td>';
                    content += '<td>' + row.mode + '</td></tr>';
                    if (row.control && row.control.enabled && row.control.connected) {
                        content += '<tr><td>' + S_LOG_DEVICES._getColName('control.cpu_util_1') + '</td><td>';
                        content += S_LOG_DEVICES.chartFormatter('', { colModel: { name: 'control.cpu_util_1' } }, row);
                        content += '</td></tr>';
                        content += '<tr><td>' + S_LOG_DEVICES._getColName('mem_pct') + '</td><td>';
                        content += S_LOG_DEVICES.chartFormatter('', { colModel: { name: 'mem_pct' } }, row);
                        content += '</td></tr>';
                        content += '<tr><td>' + S_LOG_DEVICES._getColName('control.uptime') + '</td><td>';
                        content += WGRD.timeFormatter(row.control.uptime);
                        content += '</td></tr>';
                        content += '<tr><td>' + S_LOG_DEVICES._getColName('fk_expiration') + '</td><td>';
                        content += S_LOG_DEVICES.fkFormatter(row.fk_expiration, {}, row);
                        content += '</td></tr>';
                        content += '<tr><td>' + S_LOG_DEVICES._getColName('update_time') + '</td><td>';
                        content += $.getDateDisplay(row.control.sample_time + " GMT");
                        content += '</td></tr>';
                    }
                    content += '</table>';
                    title = '<a href="/control/device?sn=' + row.id + '">' + d.name + '</a>';
                } else {
                    // Cluster with more than one member
                    content = '<table class="popup_table" style="width:95%;">';
                    content += '<tr><th style="width:40%;"></th>';
                    content += '<th>' + row.members[0].name + '</th>';
                    content += '<th>' + row.members[1].name + '</th></tr>';
                    content += '<tr><td>' + S_LOG_DEVICES._getColName('active') + '</td>';
                    content += '<td>' + S_LOG_DEVICES._parseActiveState(row.members[0].visibility) + '</td>';
                    content += '<td>' + S_LOG_DEVICES._parseActiveState(row.members[1].visibility) + '</td></tr>';
                    content += '<tr><td>' + S_LOG_DEVICES._getColName('mode') + '</td>';
                    content += '<td>' + S_LOG_DEVICES._parseActiveState(row.members[0].control) + '</td>';
                    content += '<td>' + S_LOG_DEVICES._parseActiveState(row.members[1].control) + '</td></tr>';
                    if (row.control && row.control.enabled && row.control.connected) {
                        content += '<tr><td>' + S_LOG_DEVICES._getColName('control.cpu_util_1') + '</td>';
                        content += '<td>' + S_LOG_DEVICES.pctbarFormat(row.members[0].control.cpu_util_1, color_class) + '</td>';
                        content += '<td>' + S_LOG_DEVICES.pctbarFormat(row.members[1].control.cpu_util_1, color_class) + '</td>';
                        content += '</tr>';
                        content += '<tr><td>' + S_LOG_DEVICES._getColName('mem_pct') + '</td>';
                        content += '<td>' + S_LOG_DEVICES.pctbarFormat(row.members[0].mem_pct, color_class) + '</td>';
                        content += '<td>' + S_LOG_DEVICES.pctbarFormat(row.members[1].mem_pct, color_class) + '</td>';
                        content += '</tr>';
                        content += '<tr><td>' + S_LOG_DEVICES._getColName('control.uptime') + '</td>';
                        content += '<td>' + WGRD.timeFormatter(row.members[0].control.uptime) + '</td>';
                        content += '<td>' + WGRD.timeFormatter(row.members[1].control.uptime) + '</td>';
                        content += '</tr>';
                        content += '<tr><td>' + S_LOG_DEVICES._getColName('fk_expiration') + '</td><td colspan="2">';
                        content += S_LOG_DEVICES.fkFormatter(row.fk_expiration, {}, row);
                        content += '</td></tr>';
                        content += '<tr><td>' + S_LOG_DEVICES._getColName('update_time') + '</td><td colspan="2">';
                        content += $.getDateDisplay(row.control.sample_time + " GMT");
                        content += '</td></tr>';
                    }
                    content += '</table>';

                    title = '<a href="/control/device?sn=' + row.id + '">' + d.name + '</a>';
                }
                break;
            }
        }

        $(titlediv).html(title);
        $(contentdiv).html(content);
    },

    toggleEditBtn: function () {
        // enable/disable "Edit" button depending on if any rows are selected or not
        var gridSelector = "#grid_entities";
        var selRowId = $(gridSelector).jqGrid('getGridParam', 'selrow');
        if (selRowId !== null) {
            WGRD.enableUIElements(true, ['#device_edit_btn']);
        } else {
            WGRD.enableUIElements(false, ['#device_edit_btn']);
        }
    },

    toggleRemoveBtn: function () {
        // enable/disable "Remove" button depending on if any rows are selected or not
        var gridSelector = "#grid_entities";
        S_LOG_DEVICES.toggleRemoveBtnCommon($(gridSelector).jqGrid('getGridParam', 'selrow'),
                                            gridSelector,
                                            "#device_delete_btn");
        S_LOG_DEVICES.toggleEditBtn();
    },

    toggleRemoveBtnCommon: function (selRowId, gridSelector, deleteBtnSelector) {
        // DRY'd logic shared between js objects that toggle remove buttons for the /log/devices/ page.

        if (selRowId !== null) {
            WGRD.enableUIElements(selRowId, [deleteBtnSelector]);
        } else {
            WGRD.enableUIElements(false, [deleteBtnSelector]);
        }

    },

    addDeviceAction: function () {
        DEVICE_WIZ.showDeviceDialog(S_LOG_DEVICES.ADD_DEVICE);
    },

    editDeviceAction : function () {
        DEVICE_WIZ.showDeviceDialog(S_LOG_DEVICES.EDIT_DEVICE);
    },

    removeDeviceAction: function () {
        var gridSelector = "#grid_entities";
        var selRowId = $(gridSelector).jqGrid('getGridParam', 'selrow');
        if (selRowId !== null) {
            $.ajax({
                url: 'get_device_details',
                data: {'device_id': selRowId},
                success: function (response) {
                    var device_has_members = response.device_members;
                    var device_is_cluster = response.is_cluster;

                    var logging_status = response.logging_status;
                    var management_status = response.management_status;

                    $('#confirmBoxDiv h3').text(S_REMOVE_DEVICE_TITLE);
                    $('#confirmBoxDiv modal-body').empty();
                    var msg_html = '';
                    var body_div_begin_tag = '<div>';
                    var body_div_end_tag = '</div>';
                    var confirmation_msg = '<p>' + S_REMOVE_DEVICE_CONFIRM_MSG + '</p>';
                    var logging_hidden_tag = '<input type="hidden" value="' + logging_status + '" id="logging_status"/>';
                    if (device_has_members.length) {
                        var cluster_div = '<input type="hidden" value="' + response.device_name + '" id="cluster_name"/>' +
                                          '<div class="form-horizontal">' +
                                            '<div class="control-group">' +
                                              '<label class="control-label" for="rem_cluster_select">' + S_REMOVE + '</label> ' +
                                              '<div class="controls">' +
                                                '<select id="rem_cluster_select">' +
                                                  '<option id="rem_firecluster">' + S_REMOVE_FC + '</option>' +
                                                  '<option id="rem_specific_member">' + S_REMOVE_FC_MEMBER + '</option>' +
                                                '</select>' +
                                              '</div>' +
                                            '</div>' +
                                            '<div id="rem_member_div" class="hide"></div>' +
                                          '</div><br>';

                        body_div_begin_tag = body_div_begin_tag + cluster_div;
                    } else if (device_is_cluster) {
                        body_div_begin_tag = body_div_begin_tag + '<input type="hidden" value="' + response.device_name + '" id="cluster_name"/>';
                    }

                    if (logging_status === 1 && management_status === 0) {
                        confirmation_msg = '<p>' + S_REMOVE_MGS_1 + '</p>';
                        body_div_begin_tag = body_div_begin_tag + confirmation_msg;
                    } else if (logging_status === 1) {
                        confirmation_msg = '<p>' + S_REMOVE_MGS_2 + '</p>';
                        body_div_begin_tag = body_div_begin_tag + confirmation_msg;
                    } else if (management_status === 0) {
                        confirmation_msg = '<p>' + S_REMOVE_MGS_3 + '</p>';
                        body_div_begin_tag = body_div_begin_tag + confirmation_msg;
                    } else {
                        body_div_begin_tag = body_div_begin_tag + confirmation_msg;
                    }

                    msg_html = body_div_begin_tag + logging_hidden_tag + body_div_end_tag;

                    if (logging_status === 1 && management_status === 1) {
                        WGRD.okMessageModal(msg_html);
                    } else {
                        WGRD.confirmModal(msg_html, true, S_LOG_DEVICES._removeDeviceAction, true);
                    }
                    if (device_has_members.length) {
                        $('#rem_cluster_select').on('change', S_LOG_DEVICES.toggleRemMemberUI);
                        $.each(response.device_members, function (index, value) {
                            logging_status = value.logging_status;
                            var logging_tag = '<br><span class="muted"><i>' + S_LOGGING_DISABLED_MSG + '</i></span>';
                            if (logging_status === 1) {
                                logging_tag = '<br><span class="text-info"><i>' + S_LOGGING_YES_MSG + '</i></span>';
                            } else if (logging_status === 0) {
                                logging_tag = '<br><span class="text-success"><i>' + S_LOGGING_NO_MSG + '</i></span>';
                            }
                            var member = '<div class="control-group" style="margin-bottom:1px;">' +
                                           '<div class="controls">' +
                                             '<label class="checkbox">' +
                                               '<input type="checkbox" id="' + value.id + '">' + value.name + ' (' + value.sn + ')' +
                                               logging_tag +
                                             '</label>' +

                                           '</div>' +
                                         '</div>';
                            $('#rem_member_div').append(member);
                            $("#" + value.id).on('click', S_LOG_DEVICES.enableOKButton);
                        });
                    }
                }
            });
        }
    },

    _removeDeviceAction: function () {
        WGRD.enableUIElements(false, ['#device_delete_btn']);
        var selRowId = $('#grid_entities').jqGrid('getGridParam', 'selrow');
        if (!selRowId) {
            return;
        }

        var device_id = selRowId;
        var rem_specific_member = false;
        var rem_cluster = false;
        var cluster_name = $('#cluster_name').val();
        var device_is_cluster = $('#rem_cluster_select')[0];
        if (device_is_cluster) {
            var index = $('#rem_cluster_select')[0].selectedIndex;
            if (index === 0) { // Remove entire cluster
                rem_cluster = true;
            } else {
                var all_members = $("#rem_member_div input[type='checkbox']");
                var count_checked = all_members.filter(":checked").length;
                if (count_checked === all_members.length) {
                    rem_cluster = true;
                } else {
                    var checked_member = all_members.filter(":checked");
                    device_id = checked_member.attr('id');
                    rem_specific_member = true;
                }
            }
        } else if (cluster_name !== undefined) {
            rem_cluster = true;
        }

        var appid_data = [{'device_id': device_id}];
        if (rem_cluster) {
            appid_data[0].cluster_name = cluster_name;
        }

        $.ajax({
            url: 'delete_client',
            type: 'POST',
            dataType: 'json',
            contentType: 'application/json',
            data: JSON.stringify(appid_data),
            success: function (response) {
                if (response.success) {
                    if (rem_specific_member) {
                        S_LOG_DEVICES.doRefreshTabs();
                    } else {
                        $('#grid_entities').jqGrid('delRowData', device_id);
                    }

                    WGRD.closeModal();
                } else if (response.message) {
                    WGRD.okMessageModal(response.message, S_REMOVE_DEVICE_TITLE);
                } else {
                    WGRD.okMessageModal(S_REMOVE_DEVICE_ERROR, S_REMOVE_DEVICE_TITLE);
                }
            },
            error: function () {
                WGRD.okMessageModal(S_REMOVE_DEVICE_ERROR, S_REMOVE_DEVICE_TITLE);
            },
            complete: function () {
                S_LOG_DEVICES.toggleRemoveBtn();
            }
        });
    },

    curWinSize: -1,
    doResize: function () {
        var winwidth = $(window).width();
        var w = $("#lstabs").width();
        var winSize = 0;
        if (winwidth <= 480) {
            winSize = 0;
        } else if (winwidth <= 768) {
            winSize = 1;
        } else if (winwidth < 1024) {
            winSize = 2;
        } else {
            winSize = 3;
        }
        if (winSize !== S_LOG_DEVICES.curWinSize) {
            S_LOG_DEVICES.viewSizeGrid(winSize);
        }
        S_LOG_DEVICES.curWinSize = winSize;

        var grid_width = w - 5;
        $('#grid_entities').setGridWidth(grid_width);
        S_LOG_DEVICES.doMapResize();
    },
    doRefreshTabs: function () {
        // This action refreshes the tables on the Devices, Servers and Groups tabs.
        // Note: this function is making calls to js functions outside of this file and
        //       providing a callback to monitor the status of the refresh.

        S_LOG_DEVICES.refreshing_devices = true;
        S_LOG_DEVICES.refreshing_servers = $('#lstabs a[href="#tabServers"]').is(':visible');
        S_LOG_DEVICES.refreshing_vpns = $('#lstabs a[href="#tabVpns"]').is(':visible');
        S_LOG_DEVICES.refreshing_groups = $('#lstabs a[href="#tabGroups"]').is(':visible');

        $('#btn_refresh_tabs').hide();
        $('#spinner_refresh_tabs').show();

        S_LOG_DEVICES.getGridData(function () {
            S_LOG_DEVICES.refreshing_devices = false;
            S_LOG_DEVICES._checkDoneRefreshTabs();

            //Load data for servers tab after devices tab has been populated,
            //this is done to wait for the session log_srv_list to get initialized before the 
            //control returns to the client
            L_SERVERS.getGridData(function () {
                S_LOG_DEVICES.refreshing_servers = false;
                S_LOG_DEVICES._checkDoneRefreshTabs();
            });
        });

        S_LOG_VPNS.refreshVpnsGrid(function () {
            S_LOG_DEVICES.refreshing_vpns = false;
            S_LOG_DEVICES._checkDoneRefreshTabs();
        });

        S_LOG_GROUPS.refreshGroupsGrid(function () {
            S_LOG_DEVICES.refreshing_groups = false;
            S_LOG_DEVICES._checkDoneRefreshTabs();
        });
    },

    _checkDoneRefreshTabs: function () {
        // restore the refresh button when all tabs are done refreshing
        if (!S_LOG_DEVICES.refreshing_devices && !S_LOG_DEVICES.refreshing_servers && !S_LOG_DEVICES.refreshing_vpns && !S_LOG_DEVICES.refreshing_groups) {
            $('#btn_refresh_tabs').show();
            $('#spinner_refresh_tabs').hide();
        }
    },

    toggleRemMemberUI : function () {
        var index = $('#rem_cluster_select')[0].selectedIndex;
        if (index === 0) {
            $('#rem_member_div').hide();
            $('.wgrd-modal-yes').attr('disabled', false);
        } else { // member option selected
            $('#rem_member_div').show();
            var all_members = $("#rem_member_div input[type='checkbox']");

            var count_checked = all_members.filter(":checked").length;
            if (count_checked !== 0) {
                S_LOG_DEVICES.enableOKButton();
            } else {
                S_LOG_DEVICES.enableOKButton();
            }
        }
    },

    enableOKButton : function () {
        var all_members = $("#rem_member_div input[type='checkbox']");

        var count_checked = all_members.filter(":checked").length;
        if (count_checked !== 0) {
            $('.wgrd-modal-yes').attr('disabled', false);
        } else {
            $('.wgrd-modal-yes').attr('disabled', true);
        }
    }
};
$(document).ready(S_LOG_DEVICES.init);
