/*global S_LOG_FREQUENCY, unescape, escape, checkLoginPageRedirect, S_EXPORTING_LOGS, S_PROCESSING*/
var L_SERVER = {
    allVars: '',
    urlSn: '',
    urlSearch: '',
    urlLt: 'tr',
    urlName: '',
    urlTz: '',

    init: function () {
        L_SERVER.allVars = $.getUrlVars();
        L_SERVER.urlSearch = $.getUrlVar('search');
        L_SERVER.urlName = $.getUrlVar('name');
        L_SERVER.urlSn = $.getUrlVar('sn');
        L_SERVER.urlLt = $.getUrlVar('l_t');

        L_SERVER.initUI();
        L_SERVER.initEvents();
    },

    initUI: function () {
        $("#btn_clear").hide();
        if (L_SERVER.urlSearch !== null) {
            $("#btn_clear").show();
            $("#btn_action").hide();
            $("#logtype_tabs").hide();
            $("#div_frequency").hide();
            $("#search_box").val(unescape(L_SERVER.urlSearch));
            $("#btn_actions").hide();

            $("#btn_clear").click(function () {
                $("#btn_clear").hide();
                window.location = "/log/server?sn=" + L_SERVER.urlSn + "&l_t=" + L_SERVER.urlLt + "&name=" + L_SERVER.urlName;
            });
        } else {
            $("#btn_actions").show();
            $("#search_box").val("");
        }

        $(".logViewTable").show();
    },

    initEvents: function () {
        /* -=-=-=- Search -=-=-=- */
        $("#btn_search").click(function () {
            var search = $("#search_box").val();
            if (search === '') {
                return;
            }
            window.location = "/log/server?sn=" + L_SERVER.urlSn + "&l_t=" + L_SERVER.urlLt + "&search=" + escape(search) + "&name=" + L_SERVER.urlName;
        });
        $('#search_box').bind('keypress', function (e) {
            if (e.keyCode === 13) {
                $("#btn_search").click();
            }
        });

        $('.li_action').hover(
            function () {
                var selector = "#" + this.id;
                $(selector).css("background-color", "#333");
                $(selector).css("color", "#fff");
            },
            function () {
                var selector = "#" + this.id;
                $(selector).css("background-color", "#fff");
                $(selector).css("color", "black");
            }
        );

        $("#custom_datepicker_trigger").bind('click', function () {
            // Listen for a click on this div, it means the date changed 
            // and a refresh is needed
            L_SERVER.getGridData();
        });

        /* Register a handler for selecting a predefined time range */
        $(".li_action").bind('click', function (event) {
            event.preventDefault();
            switch (this.id) {
            case "csv":
                WGRD.progressModal(S_EXPORTING_LOGS, S_PROCESSING);
                $.ajax({
                    url: "/log/export?id=" + L_SERVER.urlSn + "&l_t=" + L_SERVER.urlLt + "&name=" + L_SERVER.urlName + "&client_tz=" + WGRD.client_tz,
                    method: 'GET',
                    dataType: 'json',
                    error: checkLoginPageRedirect,
                    success: function (data) {
                        if (!data.status) {
                            if (data.message) {
                                WGRD.okMessageModal(data.message);
                            }
                            return true;
                        }
                        var file_args = '&tmp_file_name=' + data.tmp_file_name + '&file_name=' + data.file_name;
                        window.location = "/log/get_export_file?id=" + L_SERVER.urlSn + file_args;
                        return false;
                    },
                    complete: function (filename) {
                        WGRD.progressModalClose();
                    }
                });
                break;
            }
        });

        $("#btn_refresh").click(function (e) {
            e.preventDefault();
            /* Reload the grid data */
            $("#logs_grid").setGridParam().trigger("reloadGrid");

            /* Tell the log frequency graph to update */
            if (L_SERVER.urlSearch === null) {
                S_LOG_FREQUENCY.getChartData();
            }
        });

        $(window).bind('resizeEnd', function () {
            var fpwidth = $("#main_div_row").width();
            fpwidth -= $(".date_navbar_td").width();
            var padleft = 0;
            var grid_width = fpwidth - padleft * 2;

            if (L_SERVER.urlSearch === null) {
                $('#logs_grid').setGridWidth(grid_width);
                S_LOG_FREQUENCY.doResize();
            } else {
                $('#logs_search').setGridWidth(grid_width);
            }
        });
    },

    getGridData: function () {
        $.ajax({
            url: 'log_grid_columns?l_t=' + L_SERVER.urlLt,
            method: 'GET',
            dataType: 'json',
            success: L_SERVER.onColumnDataReceived
        });
    },

    utcDateFormatter: function (cellvalue, options, rowObject) {
        return $.getDateDisplay(cellvalue, true, L_SERVER.urlTz);
    },

    boldify: function (elem, src, sub, offset) {
        var pos = src.toLowerCase().indexOf(sub.toLowerCase(), offset);
        if (pos === -1) {
            return src;
        }
        var searchlen = sub.length;
        var highlight = '<font style="font-weight:bold;">' + src.substring(pos, pos + searchlen) + '</font>';
        var result = src.substring(0, pos) + highlight + src.substring(pos + searchlen);

        return L_SERVER.boldify(elem, result, sub, pos + highlight.length);
    },

    onColumnDataReceived: function (columns) {
        var padleft = parseInt($("#grid_parent").css('margin-left'), 10);
        var grid_width = $("#grid_parent").width() - padleft * 2;

        if (L_SERVER.urlSearch === null) {
            // Unload the grid and then recreate it 
            jQuery("#logs_grid").GridUnload("#logs_grid");

            /* Traffic log grid */
            $("#logs_grid").jqGrid({
                altRows: true,
                altclass: 'gridAltRow',
                autoencode: true,
                url: 'logs_server',
                datatype: 'json',
                mtype: 'GET',
                colNames: columns.col_names,
                colModel: columns.col_model,
                pager: '#pager',
                pagerpos: 'right',
                loadui: 'block',
                rowNum: 25,
                rowList: [25, 100, 250, 500],
                sortname: 'update_time',
                sortorder: 'asc',
                caption: '',
                height: 'auto',
                width: grid_width,
                viewrecords: true,
                recordpos: 'left',
                toppager: true,
                shrinkToFit: true,
                jsonReader: {
                    root: "data",
                    page: "currpage",
                    total: "totalpages",
                    records: "totalrecords",
                    repeatitems: false,
                    id: "sid"
                },
                loadError: checkLoginPageRedirect,
                loadComplete: function (data) {
                    $(window).resize();
                }
            }).navGrid("#pager", { refresh: false, search: false, edit: false, add: false, del: false }, {}, { width: 350 }, {});

            $("#logs_grid").setColProp('update_time', { formatter: L_SERVER.utcDateFormatter });
        } else {
            /* Search log grid - Pager rules are slightly different (no total record count known) */
            $("#logs_search").jqGrid({
                altRows: true,
                altclass: 'gridAltRow',
                autoencode: true,
                url: 'log_server_search',
                datatype: 'json',
                mtype: 'GET',
                colNames: columns.col_names,
                colModel: columns.col_model,
                pager: '#pager',
                pagerpos: 'right',
                loadui: 'block',
                rowNum: 25,
                rowList: [25, 100, 250, 500],
                sortname: 'update_time',
                sortorder: 'desc',
                caption: '',
                height: 'auto',
                width: grid_width,
                pginput: false,
                pgtext: false,
                viewrecords: true,
                recordpos: 'left',
                recordtext: '{0} - {1}',
                toppager: true,
                jsonReader: {
                    root: "data",
                    page: "currpage",
                    total: "totalpages",
                    records: "totalrecords",
                    repeatitems: false,
                    id: "sid"
                },
                loadError: checkLoginPageRedirect,
                loadComplete: function (data) {
                    var rowNum = $("#logs_search").getGridParam('rowNum');
                    if (data.currpage === 1) {
                        $("#prev_t_logs_search_toppager, #first_t_logs_search_toppager, #prev_pager, #first_pager").hide();
                    } else {
                        $("#prev_t_logs_search_toppager, #first_t_logs_search_toppager, #prev_pager, #first_pager").show();
                    }
                    /* Disable the next button */
                    if (data.count < rowNum) {
                        $("#next_t_logs_search_toppager, #next_pager").addClass('ui-state-disabled');
                        $("#next_t_logs_search_toppager").attr('id', 'next_t_logs_search_toppager2');
                        $("#next_pager").attr('id', 'next_pager2');
                    } else {
                        $("#next_t_logs_search_toppager2").attr('id', 'next_t_logs_search_toppager');
                        $("#next_pager2").attr('id', 'next_pager');
                        $("#next_t_logs_search_toppager, #next_pager").removeClass('ui-state-disabled');
                    }
                    /* Disable the last button, since no total record count known */
                    $("#last_t_logs_search_toppager, #last_pager").hide();
                    $("#logs_search td").each(function (index, elem) {
                        var src = $(this).text().replace(/&/g, "&amp;").replace(/>/g, "&gt;").replace(/</g, "&lt;").replace(/\"/g, "&quot;");
                        var searchstr = decodeURIComponent(L_SERVER.urlSearch);
                        var pos = src.toLowerCase().indexOf(searchstr.toLowerCase());
                        if (-1 !== pos) {
                            var result = L_SERVER.boldify($(this), src, searchstr, 0);
                            $(elem).html(result);
                        }
                    });
                    $(window).resize();
                }
            }).navGrid("#pager", { refresh: false, search: false, edit: false, add: false, del: false }, {}, { width: 350 }, {});

            $("#logs_search").setColProp('update_time', { formatter: L_SERVER.utcDateFormatter });
        }

        /* Tell the log frequency graph to update */
        if (L_SERVER.urlSearch === null) {
            S_LOG_FREQUENCY.getChartData();
        }
    }
};
$(document).ready(L_SERVER.init);
